import copy
from typing import Dict, List, Optional

def json_connection_id(connection_uuid : str):
    return {'connection_uuid': {'uuid': connection_uuid}}

def json_connection(
        connection_uuid : str, service_id : Optional[Dict] = None, path_hops_endpoint_ids : List[Dict] = [],
        sub_service_ids : List[Dict] = []
    ):

    result = {
        'connection_id'         : json_connection_id(connection_uuid),
        'path_hops_endpoint_ids': copy.deepcopy(path_hops_endpoint_ids),
        'sub_service_ids'       : copy.deepcopy(sub_service_ids),
    }
    if service_id is not None: result['service_id'] = copy.deepcopy(service_id)
    return result
