# 1.4. Access TeraFlowSDN WebUI and Grafana Dashboards

This section describes how to get access to the TeraFlowSDN controller WebUI and the monitoring Grafana dashboards.


## 1.4.1. Access the TeraFlowSDN WebUI
If you followed the installation steps based on MicroK8s, you got an ingress controller installed that exposes on TCP
port 80. In the creation of the VM, a forward from local TCP port 8080 to VM's TCP port 80 is configured, so the WebUIs
and REST APIs of TeraFlowSDN should be exposed on endpoint `127.0.0.1:8080`.
Besides, the ingress controller defines the following reverse proxy paths:
- `http://127.0.0.1:8080/webui`: points to the WebUI of TeraFlowSDN.
- `http://127.0.0.1:8080/grafana`: points to the Grafana dashboards. This endpoint brings access to the monitoring
  dashboards of TeraFlowSDN. The credentials for the `admin`user are those defined in the `my_deploy.sh` script, in the
  `TFS_GRAFANA_PASSWORD` variable.
- `http://127.0.0.1:8080/context`: points to the REST API exposed by the TeraFlowSDN Context component. This endpoint
  is mainly used for debugging purposes. Note that this endpoint is designed to be accessed from the WebUI.
- `http://127.0.0.1:8080/restconf`: points to the Compute component NBI based on RestCONF. This endpoint enables
  connecting external software, such as ETSI OpenSourceMANO NFV Orchestrator, to TeraFlowSDN.
