/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolRect
extends USymbol {
    public USymbolRect(ColorParam colorParam, ColorParam colorParam2, FontParam fontParam, FontParam fontParam2) {
        super(colorParam, colorParam2, fontParam, fontParam2);
    }

    private void drawRect(UGraphic uGraphic, double d, double d2, boolean bl) {
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.draw(uRectangle);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    public TextBlock asSmall(final TextBlock textBlock, final TextBlock textBlock2, final SymbolContext symbolContext) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolRect.this.drawRect(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolRect.this.getMargin();
                TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
                textBlock3.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock2.calculateDimension(stringBounder);
                return USymbolRect.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolRect.this.drawRect(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D2.getWidth()) / 2.0;
                textBlock2.drawU(uGraphic.apply(new UTranslate(d3, 2.0)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d22 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d22, 2.0 + dimension2D2.getHeight())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }
}

