# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import pytest
import logging
from unittest.mock import patch, MagicMock
from src.telemetry.backend.collectors.gnmi_openconfig.GnmiOpenConfigCollector import GnmiOpenConfigCollector

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(autouse=True)
def log_all_methods(request):
    LOGGER.info(f" >>>>> Starting test: {request.node.name} ")
    yield
    LOGGER.info(f" <<<<< Finished test: {request.node.name} ")

@pytest.fixture()
def gnmi_openconfig_driver():
    collector = GnmiOpenConfigCollector(
        "192.168.1.1", 
        57400, 
        secure   = True,
        username = "admin",
        password = "secret",
        use_tls  = False
    )
    LOGGER.info("Yielding GnmiOpenConfigCollector collector instance ...")
    yield collector
    LOGGER.info("Terminating GnmiOpenConfigCollector collector instance ...")

# def test_init(gnmi_openconfig_driver):
#     # Test initializing the driver with all parameters
#     driver = gnmi_openconfig_driver
#     assert driver.address == "192.168.1.1"
#     assert driver.port    == 57400



