# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from common.DeviceTypes           import DeviceTypeEnum
from common.proto.context_pb2     import DeviceDriverEnum
from telemetry.backend.Config     import LOAD_ALL_DEVICE_DRIVERS
from ..collector_api.FilterFields import FilterFieldEnum

DRIVERS = []

from .emulated.EmulatedCollector import EmulatedCollector # pylint: disable=wrong-import-position
DRIVERS.append(
    (EmulatedCollector, [
        # TODO: multi-filter is not working
        {
            FilterFieldEnum.DEVICE_TYPE: [
                DeviceTypeEnum.EMULATED_P4_SWITCH,
                DeviceTypeEnum.EMULATED_PACKET_ROUTER,
                DeviceTypeEnum.EMULATED_PACKET_SWITCH,
            ],
            FilterFieldEnum.DRIVER: [
                DeviceDriverEnum.DEVICEDRIVER_UNDEFINED,
            ],
        },
    ]))

if LOAD_ALL_DEVICE_DRIVERS:
    from .gnmi_openconfig.GnmiOpenConfigCollector import GnmiOpenConfigCollector # pylint: disable=wrong-import-position
    DRIVERS.append(
        (GnmiOpenConfigCollector, [
            {
                # Real Packet Router, specifying OpenConfig Driver => use OpenConfigDriver
                FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.PACKET_ROUTER,
                FilterFieldEnum.DRIVER     : DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG,
            }
        ]))

if LOAD_ALL_DEVICE_DRIVERS:
    from .p4.p4_collector import P4Collector # pylint: disable=wrong-import-position
    DRIVERS.append(
        (P4Collector, [
            {
                # Real P4 Switch, specifying P4 Collector => use P4Collector
                FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.P4_SWITCH,
                FilterFieldEnum.DRIVER     : DeviceDriverEnum.DEVICEDRIVER_P4,
            }
        ]))
