#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


kubectl delete namespace tfs-e2e tfs-ip

echo "Deploying tfs-e2e ..."
kubectl delete -f src/tests/ecoc24/nginx-ingress-controller-e2e.yaml                > ./tmp/logs/deploy-tfs-e2e.log
kubectl create namespace tfs-e2e                                                    > ./tmp/logs/deploy-tfs-e2e.log
kubectl apply -f src/tests/ecoc24/nginx-ingress-controller-e2e.yaml                 > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/contextservice.yaml            > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/deviceservice.yaml             > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/e2eorchestratorservice.yaml    > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/pathcompservice.yaml           > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/serviceservice.yaml            > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/sliceservice.yaml              > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/manifests/webuiservice.yaml              > ./tmp/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ecoc24/tfs-ingress-e2e.yaml                    > ./tmp/logs/deploy-tfs-e2e.log
printf "\n"

echo "Deploying tfs-ip ..."
kubectl delete -f src/tests/ecoc24/nginx-ingress-controller-ip.yaml                 > ./tmp/logs/deploy-tfs-ip.log
kubectl create namespace tfs-ip                                                     > ./tmp/logs/deploy-tfs-ip.log
kubectl apply -f src/tests/ecoc24/nginx-ingress-controller-ip.yaml                  > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/contextservice.yaml             > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/deviceservice.yaml              > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/pathcompservice.yaml            > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/serviceservice.yaml             > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/sliceservice.yaml               > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/vntmanagerservice.yaml          > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/manifests/webuiservice.yaml               > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ecoc24/tfs-ingress-ip.yaml                      > ./tmp/logs/deploy-tfs-ip.log
printf "\n"

echo "Waiting tfs-e2e ..."
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/contextservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/deviceservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/e2eorchestratorservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/pathcompservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/serviceservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/sliceservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/webuiservice
printf "\n"

echo "Waiting tfs-ip ..."
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/contextservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/deviceservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/pathcompservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/serviceservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/sliceservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/vntmanagerservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/webuiservice
printf "\n"

echo "Done!"
