# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiConnectivityConnectionSpecReference(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, connection_spec_name: str=None, connection_spec_id: str=None):  # noqa: E501
        """TapiConnectivityConnectionSpecReference - a model defined in Swagger

        :param connection_spec_name: The connection_spec_name of this TapiConnectivityConnectionSpecReference.  # noqa: E501
        :type connection_spec_name: str
        :param connection_spec_id: The connection_spec_id of this TapiConnectivityConnectionSpecReference.  # noqa: E501
        :type connection_spec_id: str
        """
        self.swagger_types = {
            'connection_spec_name': str,
            'connection_spec_id': str
        }

        self.attribute_map = {
            'connection_spec_name': 'connection-spec-name',
            'connection_spec_id': 'connection-spec-id'
        }
        self._connection_spec_name = connection_spec_name
        self._connection_spec_id = connection_spec_id

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityConnectionSpecReference':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.ConnectionSpecReference of this TapiConnectivityConnectionSpecReference.  # noqa: E501
        :rtype: TapiConnectivityConnectionSpecReference
        """
        return util.deserialize_model(dikt, cls)

    @property
    def connection_spec_name(self) -> str:
        """Gets the connection_spec_name of this TapiConnectivityConnectionSpecReference.

        The name of the connection spec.                  This can be used alone (with no spec reference) where there is only a paper spec.  # noqa: E501

        :return: The connection_spec_name of this TapiConnectivityConnectionSpecReference.
        :rtype: str
        """
        return self._connection_spec_name

    @connection_spec_name.setter
    def connection_spec_name(self, connection_spec_name: str):
        """Sets the connection_spec_name of this TapiConnectivityConnectionSpecReference.

        The name of the connection spec.                  This can be used alone (with no spec reference) where there is only a paper spec.  # noqa: E501

        :param connection_spec_name: The connection_spec_name of this TapiConnectivityConnectionSpecReference.
        :type connection_spec_name: str
        """

        self._connection_spec_name = connection_spec_name

    @property
    def connection_spec_id(self) -> str:
        """Gets the connection_spec_id of this TapiConnectivityConnectionSpecReference.

        The reference to a formal spec.                   This reference need not be provided (e.g., where there is no formal machine interpretable spec for the type of connection).  # noqa: E501

        :return: The connection_spec_id of this TapiConnectivityConnectionSpecReference.
        :rtype: str
        """
        return self._connection_spec_id

    @connection_spec_id.setter
    def connection_spec_id(self, connection_spec_id: str):
        """Sets the connection_spec_id of this TapiConnectivityConnectionSpecReference.

        The reference to a formal spec.                   This reference need not be provided (e.g., where there is no formal machine interpretable spec for the type of connection).  # noqa: E501

        :param connection_spec_id: The connection_spec_id of this TapiConnectivityConnectionSpecReference.
        :type connection_spec_id: str
        """

        self._connection_spec_id = connection_spec_id
