# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server import util


class TapiCommonLocalClass(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None):  # noqa: E501
        """TapiCommonLocalClass - a model defined in Swagger

        :param name: The name of this TapiCommonLocalClass.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiCommonLocalClass.  # noqa: E501
        :type local_id: str
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id'
        }
        self._name = name
        self._local_id = local_id

    @classmethod
    def from_dict(cls, dikt) -> 'TapiCommonLocalClass':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.common.LocalClass of this TapiCommonLocalClass.  # noqa: E501
        :rtype: TapiCommonLocalClass
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiCommonLocalClass.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiCommonLocalClass.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiCommonLocalClass.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiCommonLocalClass.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiCommonLocalClass.

        none  # noqa: E501

        :return: The local_id of this TapiCommonLocalClass.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiCommonLocalClass.

        none  # noqa: E501

        :param local_id: The local_id of this TapiCommonLocalClass.
        :type local_id: str
        """

        self._local_id = local_id
