# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import vlan_classification
class supported_classification(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-svc/supported-classification. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Service classification capability supported by the
Ethernet Link Termination Point (LTP).
  """
  __slots__ = ('_path_helper', '_extmethods', '__port_classification','__vlan_classification',)

  _yang_name = 'supported-classification'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__port_classification = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="port-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    self.__vlan_classification = YANGDynClass(base=vlan_classification.vlan_classification, is_container='container', yang_name="vlan-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-svc', 'supported-classification']

  def _get_port_classification(self):
    """
    Getter method for port_classification, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_classification/port_classification (boolean)

    YANG Description: Indicates that the ETH LTP support port-based service
classification.
    """
    return self.__port_classification
      
  def _set_port_classification(self, v, load=False):
    """
    Setter method for port_classification, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_classification/port_classification (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_classification is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_classification() directly.

    YANG Description: Indicates that the ETH LTP support port-based service
classification.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="port-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_classification must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="port-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__port_classification = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_classification(self):
    self.__port_classification = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="port-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='boolean', is_config=True)


  def _get_vlan_classification(self):
    """
    Getter method for vlan_classification, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_classification/vlan_classification (container)

    YANG Description: Service classification capabilities based on the VLAN
tag(s) supported by the ETH LTP.
    """
    return self.__vlan_classification
      
  def _set_vlan_classification(self, v, load=False):
    """
    Setter method for vlan_classification, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_classification/vlan_classification (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_classification is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_classification() directly.

    YANG Description: Service classification capabilities based on the VLAN
tag(s) supported by the ETH LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=vlan_classification.vlan_classification, is_container='container', yang_name="vlan-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_classification must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=vlan_classification.vlan_classification, is_container='container', yang_name="vlan-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__vlan_classification = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_classification(self):
    self.__vlan_classification = YANGDynClass(base=vlan_classification.vlan_classification, is_container='container', yang_name="vlan-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

  port_classification = __builtin__.property(_get_port_classification, _set_port_classification)
  vlan_classification = __builtin__.property(_get_vlan_classification, _set_vlan_classification)


  _pyangbind_elements = OrderedDict([('port_classification', port_classification), ('vlan_classification', vlan_classification), ])


