from common.proto.qkd_app_pb2 import AppId
from common.method_wrappers.ServiceExceptions import InvalidArgumentsException
from ._Builder import get_uuid_from_string, get_uuid_random

def app_get_uuid(
    app_id : AppId, allow_random : bool = False
) -> str:
    app_uuid = app_id.app_uuid.uuid

    if len(app_uuid) > 0:
        return get_uuid_from_string(app_uuid)
    if allow_random: return get_uuid_random()

    raise InvalidArgumentsException([
        ('app_id.app_uuid.uuid', app_uuid),
    ], extra_details=['At least one is required to produce a App UUID'])
