/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.font.TextLayout;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UnusedSpace;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.svg.DriverTextAsPathSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverCenteredCharacterSvg
implements UDriver<SvgGraphics> {
    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UCenteredCharacter uCenteredCharacter = (UCenteredCharacter)uShape;
        char c = uCenteredCharacter.getChar();
        UFont uFont = uCenteredCharacter.getFont();
        UnusedSpace unusedSpace = UnusedSpace.getUnusedSpace(uFont, c);
        double d3 = d - unusedSpace.getCenterX() - 0.5;
        double d4 = d2 - unusedSpace.getCenterY() - 0.5;
        TextLayout textLayout = new TextLayout("" + c, uFont.getFont(), TextBlockUtils.getFontRenderContext());
        svgGraphics.setStrokeColor(StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getColor())));
        DriverTextAsPathSvg.drawPathIterator(svgGraphics, d3, d4, textLayout.getOutline(null).getPathIterator(null));
    }
}

