/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileGroup
extends AbstractFtile {
    private final double diffYY = 25.0;
    private final Ftile inner;
    private final TextBlock name;
    private final HtmlColor color;

    public FtileGroup(Ftile ftile, Display display, HtmlColor htmlColor, ISkinSimple iSkinSimple) {
        super(ftile.shadowing());
        this.inner = new FtileMarged(ftile, 10.0);
        this.color = htmlColor;
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.name = display == null ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private UTranslate getTranslate() {
        return new UTranslate(0.0, 25.0);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
        if (ftileGeometry.hasPointOut()) {
            return new FtileGeometry(ftileGeometry.getWidth(), ftileGeometry.getHeight() + 50.0, ftileGeometry.getLeft(), ftileGeometry.getInY() + 25.0, ftileGeometry.getOutY() + 25.0);
        }
        return new FtileGeometry(ftileGeometry.getWidth(), ftileGeometry.getHeight() + 50.0, ftileGeometry.getLeft(), ftileGeometry.getInY() + 25.0);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        FtileGeometry ftileGeometry = this.calculateDimension(uGraphic.getStringBounder());
        SymbolContext symbolContext = new SymbolContext(HtmlColorUtils.WHITE, HtmlColorUtils.BLACK).withShadow(this.shadowing()).withStroke(new UStroke(2.0));
        USymbol.FRAME.asBig(this.name, TextBlockUtils.empty(0.0, 0.0), ((Dimension2D)ftileGeometry).getWidth(), ((Dimension2D)ftileGeometry).getHeight(), symbolContext).drawU(uGraphic);
        uGraphic.apply(this.getTranslate()).draw(this.inner);
    }

    @Override
    public boolean isKilled() {
        return false;
    }
}

