# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import path_metric
from . import path_affinities_values
from . import path_affinity_names
from . import path_srlgs_lists
from . import path_srlgs_names
from . import path_route_objects
class path_properties(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/te-node-attributes/connectivity-matrices/connectivity-matrix/path-properties. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The TE path properties.
  """
  __slots__ = ('_path_helper', '_extmethods', '__path_metric','__path_affinities_values','__path_affinity_names','__path_srlgs_lists','__path_srlgs_names','__path_route_objects',)

  _yang_name = 'path-properties'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path_metric = YANGDynClass(base=YANGListType("metric_type",path_metric.path_metric, yang_name="path-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None), is_container='list', yang_name="path-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    self.__path_affinities_values = YANGDynClass(base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__path_affinity_names = YANGDynClass(base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__path_srlgs_lists = YANGDynClass(base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__path_srlgs_names = YANGDynClass(base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__path_route_objects = YANGDynClass(base=path_route_objects.path_route_objects, is_container='container', yang_name="path-route-objects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'te-node-attributes', 'connectivity-matrices', 'connectivity-matrix', 'path-properties']

  def _get_path_metric(self):
    """
    Getter method for path_metric, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_metric (list)

    YANG Description: TE path metric type.
    """
    return self.__path_metric
      
  def _set_path_metric(self, v, load=False):
    """
    Setter method for path_metric, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_metric (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_metric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_metric() directly.

    YANG Description: TE path metric type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("metric_type",path_metric.path_metric, yang_name="path-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None), is_container='list', yang_name="path-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_metric must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("metric_type",path_metric.path_metric, yang_name="path-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None), is_container='list', yang_name="path-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__path_metric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_metric(self):
    self.__path_metric = YANGDynClass(base=YANGListType("metric_type",path_metric.path_metric, yang_name="path-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None), is_container='list', yang_name="path-metric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)


  def _get_path_affinities_values(self):
    """
    Getter method for path_affinities_values, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_affinities_values (container)

    YANG Description: Path affinities represented as values.
    """
    return self.__path_affinities_values
      
  def _set_path_affinities_values(self, v, load=False):
    """
    Setter method for path_affinities_values, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_affinities_values (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_affinities_values is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_affinities_values() directly.

    YANG Description: Path affinities represented as values.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_affinities_values must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_affinities_values = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_affinities_values(self):
    self.__path_affinities_values = YANGDynClass(base=path_affinities_values.path_affinities_values, is_container='container', yang_name="path-affinities-values", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_path_affinity_names(self):
    """
    Getter method for path_affinity_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_affinity_names (container)

    YANG Description: Path affinities represented as names.
    """
    return self.__path_affinity_names
      
  def _set_path_affinity_names(self, v, load=False):
    """
    Setter method for path_affinity_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_affinity_names (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_affinity_names is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_affinity_names() directly.

    YANG Description: Path affinities represented as names.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_affinity_names must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_affinity_names = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_affinity_names(self):
    self.__path_affinity_names = YANGDynClass(base=path_affinity_names.path_affinity_names, is_container='container', yang_name="path-affinity-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_path_srlgs_lists(self):
    """
    Getter method for path_srlgs_lists, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_srlgs_lists (container)

    YANG Description: Path SRLG properties container.
    """
    return self.__path_srlgs_lists
      
  def _set_path_srlgs_lists(self, v, load=False):
    """
    Setter method for path_srlgs_lists, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_srlgs_lists (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_srlgs_lists is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_srlgs_lists() directly.

    YANG Description: Path SRLG properties container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_srlgs_lists must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_srlgs_lists = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_srlgs_lists(self):
    self.__path_srlgs_lists = YANGDynClass(base=path_srlgs_lists.path_srlgs_lists, is_container='container', yang_name="path-srlgs-lists", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_path_srlgs_names(self):
    """
    Getter method for path_srlgs_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_srlgs_names (container)

    YANG Description: Container for the list of named SRLGs.
    """
    return self.__path_srlgs_names
      
  def _set_path_srlgs_names(self, v, load=False):
    """
    Setter method for path_srlgs_names, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_srlgs_names (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_srlgs_names is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_srlgs_names() directly.

    YANG Description: Container for the list of named SRLGs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_srlgs_names must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_srlgs_names = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_srlgs_names(self):
    self.__path_srlgs_names = YANGDynClass(base=path_srlgs_names.path_srlgs_names, is_container='container', yang_name="path-srlgs-names", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_path_route_objects(self):
    """
    Getter method for path_route_objects, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_route_objects (container)

    YANG Description: Container for the list of route objects either returned by
the computation engine or actually used by an LSP.
    """
    return self.__path_route_objects
      
  def _set_path_route_objects(self, v, load=False):
    """
    Setter method for path_route_objects, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/connectivity_matrix/path_properties/path_route_objects (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_route_objects is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_route_objects() directly.

    YANG Description: Container for the list of route objects either returned by
the computation engine or actually used by an LSP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_route_objects.path_route_objects, is_container='container', yang_name="path-route-objects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_route_objects must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_route_objects.path_route_objects, is_container='container', yang_name="path-route-objects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_route_objects = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_route_objects(self):
    self.__path_route_objects = YANGDynClass(base=path_route_objects.path_route_objects, is_container='container', yang_name="path-route-objects", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  path_metric = __builtin__.property(_get_path_metric)
  path_affinities_values = __builtin__.property(_get_path_affinities_values)
  path_affinity_names = __builtin__.property(_get_path_affinity_names)
  path_srlgs_lists = __builtin__.property(_get_path_srlgs_lists)
  path_srlgs_names = __builtin__.property(_get_path_srlgs_names)
  path_route_objects = __builtin__.property(_get_path_route_objects)


  _pyangbind_elements = OrderedDict([('path_metric', path_metric), ('path_affinities_values', path_affinities_values), ('path_affinity_names', path_affinity_names), ('path_srlgs_lists', path_srlgs_lists), ('path_srlgs_names', path_srlgs_names), ('path_route_objects', path_route_objects), ])


