# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class last_switchover_reason(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/state/last-switchover-reason. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
  """
  __slots__ = ('_path_helper', '_extmethods', '__trigger','__details',)

  _yang_name = 'last-switchover-reason'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__trigger = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)
    self.__details = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'last-switchover-reason']

  def _get_trigger(self):
    """
    Getter method for trigger, mapped from YANG variable /components/component/state/last_switchover_reason/trigger (component-redundant-role-switchover-reason-trigger)

    YANG Description: Records the generic triggers, e.g. user or system
initiated the switchover.
    """
    return self.__trigger
      
  def _set_trigger(self, v, load=False):
    """
    Setter method for trigger, mapped from YANG variable /components/component/state/last_switchover_reason/trigger (component-redundant-role-switchover-reason-trigger)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_trigger is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_trigger() directly.

    YANG Description: Records the generic triggers, e.g. user or system
initiated the switchover.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """trigger must be of a type compatible with component-redundant-role-switchover-reason-trigger""",
          'defined-type': "openconfig-platform:component-redundant-role-switchover-reason-trigger",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)""",
        })

    self.__trigger = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_trigger(self):
    self.__trigger = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)


  def _get_details(self):
    """
    Getter method for details, mapped from YANG variable /components/component/state/last_switchover_reason/details (string)

    YANG Description: Records detailed description of why the switchover happens.
For example, when system initiated the switchover, this leaf
can be used to record the specific reason, e.g. due to critical
errors of the routing daemon in the primary role.
    """
    return self.__details
      
  def _set_details(self, v, load=False):
    """
    Setter method for details, mapped from YANG variable /components/component/state/last_switchover_reason/details (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_details is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_details() directly.

    YANG Description: Records detailed description of why the switchover happens.
For example, when system initiated the switchover, this leaf
can be used to record the specific reason, e.g. due to critical
errors of the routing daemon in the primary role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """details must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__details = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_details(self):
    self.__details = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)

  trigger = __builtin__.property(_get_trigger)
  details = __builtin__.property(_get_details)


  _pyangbind_elements = OrderedDict([('trigger', trigger), ('details', details), ])


class last_switchover_reason(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/state/last-switchover-reason. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: For components that have redundant roles (e.g. two
supervisors in a device, one as primary the other as secondary),
this reports the reason of the last change of the
component's role.
  """
  __slots__ = ('_path_helper', '_extmethods', '__trigger','__details',)

  _yang_name = 'last-switchover-reason'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__trigger = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)
    self.__details = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'state', 'last-switchover-reason']

  def _get_trigger(self):
    """
    Getter method for trigger, mapped from YANG variable /components/component/state/last_switchover_reason/trigger (component-redundant-role-switchover-reason-trigger)

    YANG Description: Records the generic triggers, e.g. user or system
initiated the switchover.
    """
    return self.__trigger
      
  def _set_trigger(self, v, load=False):
    """
    Setter method for trigger, mapped from YANG variable /components/component/state/last_switchover_reason/trigger (component-redundant-role-switchover-reason-trigger)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_trigger is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_trigger() directly.

    YANG Description: Records the generic triggers, e.g. user or system
initiated the switchover.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """trigger must be of a type compatible with component-redundant-role-switchover-reason-trigger""",
          'defined-type': "openconfig-platform:component-redundant-role-switchover-reason-trigger",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)""",
        })

    self.__trigger = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_trigger(self):
    self.__trigger = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'USER_INITIATED': {}, 'SYSTEM_INITIATED': {}},), is_leaf=True, yang_name="trigger", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='component-redundant-role-switchover-reason-trigger', is_config=False)


  def _get_details(self):
    """
    Getter method for details, mapped from YANG variable /components/component/state/last_switchover_reason/details (string)

    YANG Description: Records detailed description of why the switchover happens.
For example, when system initiated the switchover, this leaf
can be used to record the specific reason, e.g. due to critical
errors of the routing daemon in the primary role.
    """
    return self.__details
      
  def _set_details(self, v, load=False):
    """
    Setter method for details, mapped from YANG variable /components/component/state/last_switchover_reason/details (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_details is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_details() directly.

    YANG Description: Records detailed description of why the switchover happens.
For example, when system initiated the switchover, this leaf
can be used to record the specific reason, e.g. due to critical
errors of the routing daemon in the primary role.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """details must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__details = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_details(self):
    self.__details = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="details", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)

  trigger = __builtin__.property(_get_trigger)
  details = __builtin__.property(_get_details)


  _pyangbind_elements = OrderedDict([('trigger', trigger), ('details', details), ])


