# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/chassis/utilization/resources/resource/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each resource.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__used','__committed','__free','__max_limit','__high_watermark','__last_high_watermark',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization', 'resources', 'resource', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/name (string)

    YANG Description: Resource name within the component.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Resource name within the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_used(self):
    """
    Getter method for used, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/used (uint64)

    YANG Description: Number of entries currently in use for the resource.
    """
    return self.__used
      
  def _set_used(self, v, load=False):
    """
    Setter method for used, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used() directly.

    YANG Description: Number of entries currently in use for the resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used(self):
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_committed(self):
    """
    Getter method for committed, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/committed (uint64)

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    return self.__committed
      
  def _set_committed(self, v, load=False):
    """
    Setter method for committed, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/committed (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_committed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_committed() directly.

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """committed must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__committed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_committed(self):
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_free(self):
    """
    Getter method for free, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/free (uint64)

    YANG Description: Number of entries available to use.
    """
    return self.__free
      
  def _set_free(self, v, load=False):
    """
    Setter method for free, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/free (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_free is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_free() directly.

    YANG Description: Number of entries available to use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """free must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__free = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_free(self):
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_max_limit(self):
    """
    Getter method for max_limit, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/max_limit (uint64)

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    return self.__max_limit
      
  def _set_max_limit(self, v, load=False):
    """
    Setter method for max_limit, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/max_limit (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_limit() directly.

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_limit must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__max_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_limit(self):
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_high_watermark(self):
    """
    Getter method for high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/high_watermark (uint64)

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    return self.__high_watermark
      
  def _set_high_watermark(self, v, load=False):
    """
    Setter method for high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/high_watermark (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_high_watermark() directly.

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """high_watermark must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_high_watermark(self):
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_last_high_watermark(self):
    """
    Getter method for last_high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)

    YANG Description: The time when the high-watermark was last updated
    """
    return self.__last_high_watermark
      
  def _set_last_high_watermark(self, v, load=False):
    """
    Setter method for last_high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_high_watermark() directly.

    YANG Description: The time when the high-watermark was last updated
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_high_watermark must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_high_watermark(self):
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

  name = __builtin__.property(_get_name)
  used = __builtin__.property(_get_used)
  committed = __builtin__.property(_get_committed)
  free = __builtin__.property(_get_free)
  max_limit = __builtin__.property(_get_max_limit)
  high_watermark = __builtin__.property(_get_high_watermark)
  last_high_watermark = __builtin__.property(_get_last_high_watermark)


  _pyangbind_elements = OrderedDict([('name', name), ('used', used), ('committed', committed), ('free', free), ('max_limit', max_limit), ('high_watermark', high_watermark), ('last_high_watermark', last_high_watermark), ])


class state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/chassis/utilization/resources/resource/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for each resource.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__used','__committed','__free','__max_limit','__high_watermark','__last_high_watermark',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'chassis', 'utilization', 'resources', 'resource', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/name (string)

    YANG Description: Resource name within the component.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Resource name within the component.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='string', is_config=False)


  def _get_used(self):
    """
    Getter method for used, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/used (uint64)

    YANG Description: Number of entries currently in use for the resource.
    """
    return self.__used
      
  def _set_used(self, v, load=False):
    """
    Setter method for used, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/used (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_used is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_used() directly.

    YANG Description: Number of entries currently in use for the resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """used must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__used = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_used(self):
    self.__used = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="used", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_committed(self):
    """
    Getter method for committed, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/committed (uint64)

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    return self.__committed
      
  def _set_committed(self, v, load=False):
    """
    Setter method for committed, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/committed (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_committed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_committed() directly.

    YANG Description: Number of entries currently reserved for this resource. This is only
relevant to tables which allocate a block of resource for a given
feature.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """committed must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__committed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_committed(self):
    self.__committed = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="committed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_free(self):
    """
    Getter method for free, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/free (uint64)

    YANG Description: Number of entries available to use.
    """
    return self.__free
      
  def _set_free(self, v, load=False):
    """
    Setter method for free, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/free (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_free is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_free() directly.

    YANG Description: Number of entries available to use.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """free must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__free = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_free(self):
    self.__free = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="free", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_max_limit(self):
    """
    Getter method for max_limit, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/max_limit (uint64)

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    return self.__max_limit
      
  def _set_max_limit(self, v, load=False):
    """
    Setter method for max_limit, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/max_limit (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_limit() directly.

    YANG Description: Maximum number of entries available for the resource. The value
is the theoretical maximum resource utilization possible.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_limit must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__max_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_limit(self):
    self.__max_limit = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_high_watermark(self):
    """
    Getter method for high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/high_watermark (uint64)

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    return self.__high_watermark
      
  def _set_high_watermark(self, v, load=False):
    """
    Setter method for high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/high_watermark (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_high_watermark() directly.

    YANG Description: A watermark of highest number of entries used for this resource.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """high_watermark must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)""",
        })

    self.__high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_high_watermark(self):
    self.__high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='uint64', is_config=False)


  def _get_last_high_watermark(self):
    """
    Getter method for last_high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)

    YANG Description: The time when the high-watermark was last updated
    """
    return self.__last_high_watermark
      
  def _set_last_high_watermark(self, v, load=False):
    """
    Setter method for last_high_watermark, mapped from YANG variable /components/component/chassis/utilization/resources/resource/state/last_high_watermark (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_high_watermark is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_high_watermark() directly.

    YANG Description: The time when the high-watermark was last updated
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_high_watermark must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_high_watermark = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_high_watermark(self):
    self.__last_high_watermark = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-high-watermark", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='oc-types:timeticks64', is_config=False)

  name = __builtin__.property(_get_name)
  used = __builtin__.property(_get_used)
  committed = __builtin__.property(_get_committed)
  free = __builtin__.property(_get_free)
  max_limit = __builtin__.property(_get_max_limit)
  high_watermark = __builtin__.property(_get_high_watermark)
  last_high_watermark = __builtin__.property(_get_last_high_watermark)


  _pyangbind_elements = OrderedDict([('name', name), ('used', used), ('committed', committed), ('free', free), ('max_limit', max_limit), ('high_watermark', high_watermark), ('last_high_watermark', last_high_watermark), ])


