# NETCONF TFS exercise

## 1. Interrogate Topology

```bash
# Configure basic NetConf/OpenConfig server

mkdir -p ~/yang-netconf/netconf-tfs/{git_openconfig,openconfig}
git clone https://github.com/openconfig/public.git ~/yang-netconf/netconf-tfs/git_openconfig

cd ~/yang-netconf/netconf-tfs

export PYBINDPLUGIN=`/usr/bin/env python -c 'import pyangbind; import os; print ("{}/plugin".format(os.path.dirname(pyangbind.__file__)))'`
pyang --plugindir $PYBINDPLUGIN -p git_openconfig/release/models/ -f pybind --split-class-dir openconfig \
    git_openconfig/release/models/interfaces/openconfig-interfaces.yang \
    git_openconfig/release/models/interfaces/openconfig-if-ethernet.yang \
    git_openconfig/release/models/platform/openconfig-platform.yang \
    git_openconfig/release/models/platform/openconfig-platform-port.yang

python3 serverOpenConfig.py

# Terminal 2 (client)
cd ~/yang-netconf/netconf
python3 clientTopology.py
```

### 2.2. Report a sample message following Topology YANG data model
```bash
mkdir -p sample-xml-skeleton
pyang -f sample-xml-skeleton --sample-xml-skeleton-annotations topology.yang -o sample-xml-skeleton/topology.xml
```

### 2.3. Convert Topology YANG to UML
```bash
mkdir -p uml
pyang -f uml topology.yang -o uml/topology.uml
java -jar plantuml.jar uml/topology.uml
```

### 2.4. Convert Topology YANG to Python bindings
```bash
export PYBINDPLUGIN=`/usr/bin/env python -c 'import pyangbind; import os; print ("{}/plugin".format(os.path.dirname(pyangbind.__file__)))'`
pyang -f pybind topology.yang --plugindir $PYBINDPLUGIN -o binding_topology.py
```

### 2.5. Test creation of JSON-/XML-encoded Topology messages
```bash
python topology.py
```


## 3. Connection YANG data model (exercise solution)

### 3.1. Convert Connection YANG to Text-based tree
```bash
mkdir -p tree
pyang -f tree connection.yang -o tree/connection.txt
```

### 3.2. Report a sample message following Connection YANG data model
```bash
mkdir -p sample-xml-skeleton
pyang -f sample-xml-skeleton --sample-xml-skeleton-annotations connection.yang -o sample-xml-skeleton/connection.xml
```

### 3.3. Convert Connection YANG to UML
```bash
mkdir -p uml
pyang -f uml connection.yang -o uml/connection.uml
java -jar plantuml.jar uml/connection.uml
```

### 3.4. Convert Connection YANG to Python bindings
```bash
export PYBINDPLUGIN=`/usr/bin/env python -c 'import pyangbind; import os; print ("{}/plugin".format(os.path.dirname(pyangbind.__file__)))'`
pyang -f pybind connection.yang --plugindir $PYBINDPLUGIN -o binding_connection.py
```

### 3.5. Test creation of JSON-/XML-encoded Connection messages
```bash
python topology.py
```
