import logging, pytest
from context.service.database.Tools import (
    FASTHASHER_DATA_ACCEPTED_FORMAT, FASTHASHER_ITEM_ACCEPTED_FORMAT, fast_hasher)

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

def test_fast_hasher():
    with pytest.raises(TypeError) as e:
        fast_hasher(27)
    assert str(e.value) == "data(27) must be " + FASTHASHER_DATA_ACCEPTED_FORMAT + ", found <class 'int'>"

    with pytest.raises(TypeError) as e:
        fast_hasher({27})
    assert str(e.value) == "data({27}) must be " + FASTHASHER_DATA_ACCEPTED_FORMAT + ", found <class 'set'>"

    with pytest.raises(TypeError) as e:
        fast_hasher({'27'})
    assert str(e.value) == "data({'27'}) must be " + FASTHASHER_DATA_ACCEPTED_FORMAT + ", found <class 'set'>"

    with pytest.raises(TypeError) as e:
        fast_hasher([27])
    assert str(e.value) == "data[0](27) must be " + FASTHASHER_ITEM_ACCEPTED_FORMAT + ", found <class 'int'>"

    fast_hasher('hello-world')
    fast_hasher('hello-world'.encode('UTF-8'))
    fast_hasher(['hello', 'world'])
    fast_hasher(('hello', 'world'))
    fast_hasher(['hello'.encode('UTF-8'), 'world'.encode('UTF-8')])
    fast_hasher(('hello'.encode('UTF-8'), 'world'.encode('UTF-8')))
