/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileArguments {
    private final StringBounder stringBounder;
    private final Real omega;
    private final Real origin;
    private final Map<Participant, LivingSpace> livingSpaces;
    private final Skin skin;
    private final ISkinParam skinParam;

    public TileArguments(StringBounder stringBounder, Real real, Map<Participant, LivingSpace> map, Skin skin, ISkinParam iSkinParam, Real real2) {
        this.stringBounder = stringBounder;
        this.origin = real2;
        this.omega = real;
        this.livingSpaces = map;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public final Real getOmega() {
        return this.omega;
    }

    public final Real getOrigin() {
        return this.origin;
    }

    public final Map<Participant, LivingSpace> getLivingSpaces() {
        return Collections.unmodifiableMap(this.livingSpaces);
    }

    public final Skin getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public LivingSpace getLivingSpace(Participant participant) {
        return this.livingSpaces.get(participant);
    }

    public LivingSpace getFirstLivingSpace() {
        return this.livingSpaces.entrySet().iterator().next().getValue();
    }

    public LivingSpace getLastLivingSpace() {
        LivingSpace livingSpace = null;
        Iterator<LivingSpace> iterator = this.livingSpaces.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace livingSpace2;
            livingSpace = livingSpace2 = iterator.next();
        }
        return livingSpace;
    }
}

