# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class as_number_hop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/te-node-attributes/connectivity-matrices/path-properties/path-route-objects/path-route-object/as-number-hop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: AS explicit route hop.
  """
  __slots__ = ('_path_helper', '_extmethods', '__as_number','__hop_type',)

  _yang_name = 'as-number-hop'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__as_number = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="as-number", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:as-number', is_config=False)
    self.__hop_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'te-node-attributes', 'connectivity-matrices', 'path-properties', 'path-route-objects', 'path-route-object', 'as-number-hop']

  def _get_as_number(self):
    """
    Getter method for as_number, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_properties/path_route_objects/path_route_object/as_number_hop/as_number (inet:as-number)

    YANG Description: The Autonomous System (AS) number.
    """
    return self.__as_number
      
  def _set_as_number(self, v, load=False):
    """
    Setter method for as_number, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_properties/path_route_objects/path_route_object/as_number_hop/as_number (inet:as-number)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_as_number is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_as_number() directly.

    YANG Description: The Autonomous System (AS) number.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="as-number", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:as-number', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """as_number must be of a type compatible with inet:as-number""",
          'defined-type': "inet:as-number",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="as-number", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:as-number', is_config=False)""",
        })

    self.__as_number = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_as_number(self):
    self.__as_number = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="as-number", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:as-number', is_config=False)


  def _get_hop_type(self):
    """
    Getter method for hop_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_properties/path_route_objects/path_route_object/as_number_hop/hop_type (te-hop-type)

    YANG Description: Strict or loose hop.
    """
    return self.__hop_type
      
  def _set_hop_type(self, v, load=False):
    """
    Setter method for hop_type, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/path_properties/path_route_objects/path_route_object/as_number_hop/hop_type (te-hop-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_type() directly.

    YANG Description: Strict or loose hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_type must be of a type compatible with te-hop-type""",
          'defined-type': "ietf-te-topology:te-hop-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=False)""",
        })

    self.__hop_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_type(self):
    self.__hop_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=False)

  as_number = __builtin__.property(_get_as_number)
  hop_type = __builtin__.property(_get_hop_type)

  __choices__ = {'type': {'as-number': ['as_number', 'hop_type']}}
  _pyangbind_elements = OrderedDict([('as_number', as_number), ('hop_type', hop_type), ])


