/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class SequenceDiagramArea {
    private final double sequenceWidth;
    private final double sequenceHeight;
    private double headerWidth;
    private double headerHeight;
    private double headerMargin;
    private double titleWidth;
    private double titleHeight;
    private double footerWidth;
    private double footerHeight;
    private double footerMargin;

    public SequenceDiagramArea(double d, double d2) {
        this.sequenceWidth = d;
        this.sequenceHeight = d2;
    }

    public void setTitleArea(double d, double d2) {
        this.titleWidth = d;
        this.titleHeight = d2;
    }

    public void setHeaderArea(double d, double d2, double d3) {
        this.headerWidth = d;
        this.headerHeight = d2;
        this.headerMargin = d3;
    }

    public void setFooterArea(double d, double d2, double d3) {
        this.footerWidth = d;
        this.footerHeight = d2;
        this.footerMargin = d3;
    }

    public double getWidth() {
        double d = this.sequenceWidth;
        if (this.headerWidth > d) {
            d = this.headerWidth;
        }
        if (this.titleWidth > d) {
            d = this.titleWidth;
        }
        if (this.footerWidth > d) {
            d = this.footerWidth;
        }
        return d;
    }

    public double getHeight() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin + this.footerHeight;
    }

    public double getTitleX() {
        return (this.getWidth() - this.titleWidth) / 2.0;
    }

    public double getTitleY() {
        return this.headerHeight + this.headerMargin;
    }

    public double getSequenceAreaX() {
        return (this.getWidth() - this.sequenceWidth) / 2.0;
    }

    public double getSequenceAreaY() {
        return this.getTitleY() + this.titleHeight;
    }

    public double getHeaderY() {
        return 0.0;
    }

    public double getFooterY() {
        return this.sequenceHeight + this.headerHeight + this.headerMargin + this.titleHeight + this.footerMargin;
    }

    public double getFooterX(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.footerWidth;
        }
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.footerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }

    public double getHeaderX(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            return this.getWidth() - this.headerWidth;
        }
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            return (this.getWidth() - this.headerWidth) / 2.0;
        }
        throw new IllegalStateException();
    }
}

