# ADRENALINE DLT App

<figure>
    <img src="./resources/System.png"
         alt="DLT Gateway for chaincode interaction"
         width="960"
         height="480">
    <figcaption>DLT_APP for chaincode tests.</figcaption>
</figure>

## Description

The DLT app consists of a **fabricConnect.ts** TypeScript file, which contains the logic for identification management (certificates required for the MSP), connection management to the blockchain, and finally, it exposes a contract object with all the required information for interacting with the chaincode. The **fabricConnect.ts** is coded following the Fabric Gateway API recommendations from Hyperledger Fabric 2.4+. The compiled **fabricConnect.ts** logic is imported into a **dltGateway.js** file, which contains the gRPC logic for interaction with the TFS controller. Testing code for various performance tests is included inside the [/dltApp/tests](./dltApp/tests/) folder.

The chaincode is written in Go, providing a reference for the operations that are recorded in the blockchain. This chaincode must already be deployed in a working Hyperledger Fabric blockchain.

## Requisites

* NodeJS
* Docker
* K8s

## Building the App

Install the dependencies and compile the source code.

```bash
npm install
```

## Packing the App

The [automation](./automation/) folder contains the Dockerfiles and Kubernetes configuration files alongside deployment scripts.

### Build a Docker Image

Using the Dockerfile, create a Docker image of the Gateway.

```bash
docker build -t your-username/dltgateway:v1.0.0 .
```

If necessary, upload the Docker image to a Docker repository for convenience. (You can work with the local image if deploying the Kubernetes service on the same machine.)

```bash
docker push your-username/dltgateway:v1.0.0
```

### Run the Deployment Script

Make the necessary changes to the environment variables inside the **configmap.yaml** according to the specific Fabric deployment. Also, update the path in the **persistent-volume.yaml** with the correct information.

```bash
./deploy_dlt_gateway.sh
```

Once the Kubernetes service is deployed, TFS can perform gRPC requests to as usual.