from .openconfig_routing_policy import openconfig_routing_policy
from pyangbind.lib.serialise import pybindIETFXMLEncoder

def create_rp_statement(parameters):                     #[L3] Creates a Routing Policy Statement
    Policy_Name      = parameters['policy_name']   
    DEL              = parameters['DEL']                            #If the parameter DEL is set to "TRUE" that will mean that is for making a DELETE, ELSE is for creating
           
    #Create an instance of the YANG model
    RoutingPolicy_Instance = openconfig_routing_policy()

    if DEL == True:
        #Set the Name of the Routing Policy
        Set_RoutingPolicy = RoutingPolicy_Instance.routing_policy.policy_definitions.policy_definition.add(name=Policy_Name)

        #Dump the entire instance as RFC 750 XML
        RoutingInstance_set = pybindIETFXMLEncoder.serialise(RoutingPolicy_Instance)

        RoutingInstance_set = RoutingInstance_set.replace('<openconfig-routing-policy xmlns="http://openconfig.net/yang/routing-policy">',"")
        RoutingInstance_set = RoutingInstance_set.replace('<routing-policy>','<routing-policy xmlns="http://openconfig.net/yang/routing-policy">')

        #Operation Delete [Replace]
        RoutingInstance_set = RoutingInstance_set.replace('<policy-definition>','<policy-definition xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0" nc:operation="delete">')
        RoutingInstance_set = RoutingInstance_set.replace('</openconfig-routing-policy>','')   

    else:
        Statement_Name   = parameters['statement_name']             
        Policy_Result    = parameters['policy_result']
        ExtCommSetName   = parameters['ext_community_set_name']

        #Access the entry container

        #Set the Name of the Routing Policy
        Set_RoutingPolicy = RoutingPolicy_Instance.routing_policy.policy_definitions.policy_definition.add(name=Policy_Name)
        Set_RoutingPolicy.config.name = Policy_Name

        #Configure the Statement of the Routing Policy 
        Set_Statement_RoutingPolicy = Set_RoutingPolicy.statements.statement.add(name=Statement_Name)
        Set_Statement_RoutingPolicy.config.name = Statement_Name
        Set_Statement_RoutingPolicy.conditions.config.install_protocol_eq = "DIRECTLY_CONNECTED"
        Set_Statement_RoutingPolicy.actions.config.policy_result = Policy_Result
        
        #Dump the entire instance as RFC 750 XML
        RoutingInstance_set = pybindIETFXMLEncoder.serialise(RoutingPolicy_Instance)

        #Policy-Definition - Statements - BGP-Conditions [Replace]
        RoutingInstance_set = RoutingInstance_set.replace('</conditions>','  <bgp-conditions xmlns="http://openconfig.net/yang/bgp-policy"> \n\t\t <config> \n\t    \
        <ext-community-set>'+ ExtCommSetName +'</ext-community-set> \n\t\t </config> \n\t      </bgp-conditions>\n\t    </conditions>')

        #Generic Replaces
        RoutingInstance_set = RoutingInstance_set.replace('<openconfig-routing-policy xmlns="http://openconfig.net/yang/routing-policy">',"")
        RoutingInstance_set = RoutingInstance_set.replace('<routing-policy>','<routing-policy xmlns="http://openconfig.net/yang/routing-policy">')
        RoutingInstance_set = RoutingInstance_set.replace('</openconfig-routing-policy>','') 

    return (RoutingInstance_set)

def create_rp_def(parameters):                           #[L3] Creates a Routing Policy - Defined Sets [ '/routing_policy/bgp_defined_set[{:s}_rt_export][{:s}]' ]
    ExtCommSetName   = parameters['ext_community_set_name']
    DEL              = parameters['DEL']                            #If the parameter DEL is set to "TRUE" that will mean that is for making a DELETE, ELSE is for creating             
                                                                    
    #Create an instance of the YANG model
    RoutingPolicy_Instance = openconfig_routing_policy()

    if DEL == True:                                                                                 #Delete operation
        #Dump the entire instance as RFC 750 XML
        RoutingInstance_set = pybindIETFXMLEncoder.serialise(RoutingPolicy_Instance)

        #BGP-Defined-Sets [Replace]
        RoutingInstance_set = RoutingInstance_set.replace('<openconfig-routing-policy xmlns="http://openconfig.net/yang/routing-policy"/>',
        '<routing-policy xmlns="http://openconfig.net/yang/routing-policy"> \n   <defined-sets> \n      <bgp-defined-sets xmlns="http://openconfig.net/yang/bgp-policy">\
        \n\t <ext-community-sets> \n\t   <ext-community-set xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0" nc:operation="delete"> \n      \
        <ext-community-set-name>'+ExtCommSetName+'</ext-community-set-name> \n\t   </ext-community-set> \n\t </ext-community-sets> \
         \n      </bgp-defined-sets> \n   </defined-sets> \n </routing-policy>')

    else:                                                                                            #Merge operation
        #Add new requested parameter - ext_community_member
        ExtCommMember    = parameters['ext_community_member'] 

        #Dump the entire instance as RFC 750 XML
        RoutingInstance_set = pybindIETFXMLEncoder.serialise(RoutingPolicy_Instance)

        #BGP-Defined-Sets [Replace]
        RoutingInstance_set = RoutingInstance_set.replace('<openconfig-routing-policy xmlns="http://openconfig.net/yang/routing-policy"/>',
        '<routing-policy xmlns="http://openconfig.net/yang/routing-policy"> \n   <defined-sets> \n     <bgp-defined-sets xmlns="http://openconfig.net/yang/bgp-policy">\
        \n\t<ext-community-sets> \n\t  <ext-community-set> \n\t   <ext-community-set-name>'+ExtCommSetName+'</ext-community-set-name> \n\t     <config>     \
        \n\t\t<ext-community-set-name>'+ ExtCommSetName +'</ext-community-set-name> \n\t\t<ext-community-member>'+ExtCommMember+'</ext-community-member> \n     \
        </config>  \n\t   </ext-community-set> \n\t </ext-community-sets> \n      </bgp-defined-sets> \n   </defined-sets> \n </routing-policy>')

    return (RoutingInstance_set)

