# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from enum import Enum

class DeviceTypeEnum(Enum):
    EMULATED_DATACENTER       = 'emu-datacenter'
    EMULATED_OPEN_LINE_SYSTEM = 'emu-open-line-system'
    EMULATED_PACKET_ROUTER    = 'emu-packet-router'
    DATACENTER                = 'datacenter'
    MICROVAWE_RADIO_SYSTEM    = 'microwave-radio-system'
    OPTICAL_ROADM             = 'optical-roadm'
    OPTICAL_TRANSPONDER       = 'optical-transponder'
    OPEN_LINE_SYSTEM          = 'open-line-system'
    PACKET_ROUTER             = 'packet-router'
    PACKET_SWITCH             = 'packet-switch'
    P4_SWITCH                 = 'p4-switch'
    XR_CONSTELLATION          = 'xr-constellation'
