# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_port_direction import TapiCommonPortDirection  # noqa: F401,E501
from tapi_server.models.tapi_topology_connection_spec_reference import TapiTopologyConnectionSpecReference  # noqa: F401,E501
from tapi_server.models.tapi_topology_forwarding_rule import TapiTopologyForwardingRule  # noqa: F401,E501
from tapi_server.models.tapi_topology_port_role_rule import TapiTopologyPortRoleRule  # noqa: F401,E501
from tapi_server.models.tapi_topology_rule_type import TapiTopologyRuleType  # noqa: F401,E501
from tapi_server.models.tapi_topology_signal_property_rule import TapiTopologySignalPropertyRule  # noqa: F401,E501
from tapi_server import util


class TapiTopologyRule(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, complex_rule: List[str]=None, rule_type: TapiTopologyRuleType=None, signal_property: TapiTopologySignalPropertyRule=None, connection_spec_reference: List[TapiTopologyConnectionSpecReference]=None, cep_port_role: List[TapiTopologyPortRoleRule]=None, cep_direction: List[TapiCommonPortDirection]=None, override_priority: int=None, layer_protocol_qualifier: List[str]=None, forwarding_rule: TapiTopologyForwardingRule=None):  # noqa: E501
        """TapiTopologyRule - a model defined in Swagger

        :param name: The name of this TapiTopologyRule.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiTopologyRule.  # noqa: E501
        :type local_id: str
        :param complex_rule: The complex_rule of this TapiTopologyRule.  # noqa: E501
        :type complex_rule: List[str]
        :param rule_type: The rule_type of this TapiTopologyRule.  # noqa: E501
        :type rule_type: TapiTopologyRuleType
        :param signal_property: The signal_property of this TapiTopologyRule.  # noqa: E501
        :type signal_property: TapiTopologySignalPropertyRule
        :param connection_spec_reference: The connection_spec_reference of this TapiTopologyRule.  # noqa: E501
        :type connection_spec_reference: List[TapiTopologyConnectionSpecReference]
        :param cep_port_role: The cep_port_role of this TapiTopologyRule.  # noqa: E501
        :type cep_port_role: List[TapiTopologyPortRoleRule]
        :param cep_direction: The cep_direction of this TapiTopologyRule.  # noqa: E501
        :type cep_direction: List[TapiCommonPortDirection]
        :param override_priority: The override_priority of this TapiTopologyRule.  # noqa: E501
        :type override_priority: int
        :param layer_protocol_qualifier: The layer_protocol_qualifier of this TapiTopologyRule.  # noqa: E501
        :type layer_protocol_qualifier: List[str]
        :param forwarding_rule: The forwarding_rule of this TapiTopologyRule.  # noqa: E501
        :type forwarding_rule: TapiTopologyForwardingRule
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'complex_rule': List[str],
            'rule_type': TapiTopologyRuleType,
            'signal_property': TapiTopologySignalPropertyRule,
            'connection_spec_reference': List[TapiTopologyConnectionSpecReference],
            'cep_port_role': List[TapiTopologyPortRoleRule],
            'cep_direction': List[TapiCommonPortDirection],
            'override_priority': int,
            'layer_protocol_qualifier': List[str],
            'forwarding_rule': TapiTopologyForwardingRule
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'complex_rule': 'complex-rule',
            'rule_type': 'rule-type',
            'signal_property': 'signal-property',
            'connection_spec_reference': 'connection-spec-reference',
            'cep_port_role': 'cep-port-role',
            'cep_direction': 'cep-direction',
            'override_priority': 'override-priority',
            'layer_protocol_qualifier': 'layer-protocol-qualifier',
            'forwarding_rule': 'forwarding-rule'
        }
        self._name = name
        self._local_id = local_id
        self._complex_rule = complex_rule
        self._rule_type = rule_type
        self._signal_property = signal_property
        self._connection_spec_reference = connection_spec_reference
        self._cep_port_role = cep_port_role
        self._cep_direction = cep_direction
        self._override_priority = override_priority
        self._layer_protocol_qualifier = layer_protocol_qualifier
        self._forwarding_rule = forwarding_rule

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyRule':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.Rule of this TapiTopologyRule.  # noqa: E501
        :rtype: TapiTopologyRule
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiTopologyRule.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiTopologyRule.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiTopologyRule.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiTopologyRule.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiTopologyRule.

        none  # noqa: E501

        :return: The local_id of this TapiTopologyRule.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiTopologyRule.

        none  # noqa: E501

        :param local_id: The local_id of this TapiTopologyRule.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def complex_rule(self) -> List[str]:
        """Gets the complex_rule of this TapiTopologyRule.

        Allows for more complex rules where the basic rule system is not sufficient.  # noqa: E501

        :return: The complex_rule of this TapiTopologyRule.
        :rtype: List[str]
        """
        return self._complex_rule

    @complex_rule.setter
    def complex_rule(self, complex_rule: List[str]):
        """Sets the complex_rule of this TapiTopologyRule.

        Allows for more complex rules where the basic rule system is not sufficient.  # noqa: E501

        :param complex_rule: The complex_rule of this TapiTopologyRule.
        :type complex_rule: List[str]
        """

        self._complex_rule = complex_rule

    @property
    def rule_type(self) -> TapiTopologyRuleType:
        """Gets the rule_type of this TapiTopologyRule.


        :return: The rule_type of this TapiTopologyRule.
        :rtype: TapiTopologyRuleType
        """
        return self._rule_type

    @rule_type.setter
    def rule_type(self, rule_type: TapiTopologyRuleType):
        """Sets the rule_type of this TapiTopologyRule.


        :param rule_type: The rule_type of this TapiTopologyRule.
        :type rule_type: TapiTopologyRuleType
        """

        self._rule_type = rule_type

    @property
    def signal_property(self) -> TapiTopologySignalPropertyRule:
        """Gets the signal_property of this TapiTopologyRule.


        :return: The signal_property of this TapiTopologyRule.
        :rtype: TapiTopologySignalPropertyRule
        """
        return self._signal_property

    @signal_property.setter
    def signal_property(self, signal_property: TapiTopologySignalPropertyRule):
        """Sets the signal_property of this TapiTopologyRule.


        :param signal_property: The signal_property of this TapiTopologyRule.
        :type signal_property: TapiTopologySignalPropertyRule
        """

        self._signal_property = signal_property

    @property
    def connection_spec_reference(self) -> List[TapiTopologyConnectionSpecReference]:
        """Gets the connection_spec_reference of this TapiTopologyRule.

        Identifies the type of connection that the rule applies to.                   If the attribute is not present then the rule applies to all types of connection supported by the device.  # noqa: E501

        :return: The connection_spec_reference of this TapiTopologyRule.
        :rtype: List[TapiTopologyConnectionSpecReference]
        """
        return self._connection_spec_reference

    @connection_spec_reference.setter
    def connection_spec_reference(self, connection_spec_reference: List[TapiTopologyConnectionSpecReference]):
        """Sets the connection_spec_reference of this TapiTopologyRule.

        Identifies the type of connection that the rule applies to.                   If the attribute is not present then the rule applies to all types of connection supported by the device.  # noqa: E501

        :param connection_spec_reference: The connection_spec_reference of this TapiTopologyRule.
        :type connection_spec_reference: List[TapiTopologyConnectionSpecReference]
        """

        self._connection_spec_reference = connection_spec_reference

    @property
    def cep_port_role(self) -> List[TapiTopologyPortRoleRule]:
        """Gets the cep_port_role of this TapiTopologyRule.

        Indicates the port role to which the rule applies.                   The port role is interpreted in the context of the connection type which is identified by the connection spec.                   The port role is not meaningful in the absence of a connection spec reference.                  If a node rule group carries a port role, that role applies also to the associated inter rule where the combination of the roles in the node rule groups at the ends of the inter group rule define the connection orientation.                  For example a root-and-leaf connection may be used in a node where a node rule group collects one set of NEPs has the port role 'root' and another node rule group collects another set of NEPs has the port role 'leaf' where these are joined by an inter rule group. This combination specifies an allowed orientation of the root-and-leaf connection.                  No port role statement means all port roles are allowed.  # noqa: E501

        :return: The cep_port_role of this TapiTopologyRule.
        :rtype: List[TapiTopologyPortRoleRule]
        """
        return self._cep_port_role

    @cep_port_role.setter
    def cep_port_role(self, cep_port_role: List[TapiTopologyPortRoleRule]):
        """Sets the cep_port_role of this TapiTopologyRule.

        Indicates the port role to which the rule applies.                   The port role is interpreted in the context of the connection type which is identified by the connection spec.                   The port role is not meaningful in the absence of a connection spec reference.                  If a node rule group carries a port role, that role applies also to the associated inter rule where the combination of the roles in the node rule groups at the ends of the inter group rule define the connection orientation.                  For example a root-and-leaf connection may be used in a node where a node rule group collects one set of NEPs has the port role 'root' and another node rule group collects another set of NEPs has the port role 'leaf' where these are joined by an inter rule group. This combination specifies an allowed orientation of the root-and-leaf connection.                  No port role statement means all port roles are allowed.  # noqa: E501

        :param cep_port_role: The cep_port_role of this TapiTopologyRule.
        :type cep_port_role: List[TapiTopologyPortRoleRule]
        """

        self._cep_port_role = cep_port_role

    @property
    def cep_direction(self) -> List[TapiCommonPortDirection]:
        """Gets the cep_direction of this TapiTopologyRule.

        cep direction is a list of port directions that the rule applies to.                  No entry means all cep directions.  # noqa: E501

        :return: The cep_direction of this TapiTopologyRule.
        :rtype: List[TapiCommonPortDirection]
        """
        return self._cep_direction

    @cep_direction.setter
    def cep_direction(self, cep_direction: List[TapiCommonPortDirection]):
        """Sets the cep_direction of this TapiTopologyRule.

        cep direction is a list of port directions that the rule applies to.                  No entry means all cep directions.  # noqa: E501

        :param cep_direction: The cep_direction of this TapiTopologyRule.
        :type cep_direction: List[TapiCommonPortDirection]
        """

        self._cep_direction = cep_direction

    @property
    def override_priority(self) -> int:
        """Gets the override_priority of this TapiTopologyRule.

        The overridePriority allows for one rule in a rule group to override another.                  Priority n rules override priority n+1 rules.                  Rules of the same priority override as follows (n overrides n+1):                  1 - MustNot                  2 - Must                  3 - May                  4 - Null                  Within a rule the flexibility rules (signal, port role...) override as follows (n overriedes n+1):                  1 - Any                  2 - Same                  3 - Different                  Where there are two or more 'Same' rules, they will form an intersection where all must be met.                    # noqa: E501

        :return: The override_priority of this TapiTopologyRule.
        :rtype: int
        """
        return self._override_priority

    @override_priority.setter
    def override_priority(self, override_priority: int):
        """Sets the override_priority of this TapiTopologyRule.

        The overridePriority allows for one rule in a rule group to override another.                  Priority n rules override priority n+1 rules.                  Rules of the same priority override as follows (n overrides n+1):                  1 - MustNot                  2 - Must                  3 - May                  4 - Null                  Within a rule the flexibility rules (signal, port role...) override as follows (n overriedes n+1):                  1 - Any                  2 - Same                  3 - Different                  Where there are two or more 'Same' rules, they will form an intersection where all must be met.                    # noqa: E501

        :param override_priority: The override_priority of this TapiTopologyRule.
        :type override_priority: int
        """

        self._override_priority = override_priority

    @property
    def layer_protocol_qualifier(self) -> List[str]:
        """Gets the layer_protocol_qualifier of this TapiTopologyRule.

        Qualifies a rule for a particular layerProtocol identifying the qualifiers that the rule apples to.                  If the attribute is not present then the rule applies to all relevant qualifiers of the layer protocol of the parent entity.  # noqa: E501

        :return: The layer_protocol_qualifier of this TapiTopologyRule.
        :rtype: List[str]
        """
        return self._layer_protocol_qualifier

    @layer_protocol_qualifier.setter
    def layer_protocol_qualifier(self, layer_protocol_qualifier: List[str]):
        """Sets the layer_protocol_qualifier of this TapiTopologyRule.

        Qualifies a rule for a particular layerProtocol identifying the qualifiers that the rule apples to.                  If the attribute is not present then the rule applies to all relevant qualifiers of the layer protocol of the parent entity.  # noqa: E501

        :param layer_protocol_qualifier: The layer_protocol_qualifier of this TapiTopologyRule.
        :type layer_protocol_qualifier: List[str]
        """

        self._layer_protocol_qualifier = layer_protocol_qualifier

    @property
    def forwarding_rule(self) -> TapiTopologyForwardingRule:
        """Gets the forwarding_rule of this TapiTopologyRule.


        :return: The forwarding_rule of this TapiTopologyRule.
        :rtype: TapiTopologyForwardingRule
        """
        return self._forwarding_rule

    @forwarding_rule.setter
    def forwarding_rule(self, forwarding_rule: TapiTopologyForwardingRule):
        """Sets the forwarding_rule of this TapiTopologyRule.


        :param forwarding_rule: The forwarding_rule of this TapiTopologyRule.
        :type forwarding_rule: TapiTopologyForwardingRule
        """

        self._forwarding_rule = forwarding_rule
