# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_service_interface_point import TapiCommonServiceInterfacePoint  # noqa: F401,E501
from tapi_server import util


class TapiCommonTapiContext(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, uuid: str=None, service_interface_point: List[TapiCommonServiceInterfacePoint]=None):  # noqa: E501
        """TapiCommonTapiContext - a model defined in Swagger

        :param name: The name of this TapiCommonTapiContext.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiCommonTapiContext.  # noqa: E501
        :type uuid: str
        :param service_interface_point: The service_interface_point of this TapiCommonTapiContext.  # noqa: E501
        :type service_interface_point: List[TapiCommonServiceInterfacePoint]
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'service_interface_point': List[TapiCommonServiceInterfacePoint]
        }

        self.attribute_map = {
            'name': 'name',
            'uuid': 'uuid',
            'service_interface_point': 'service-interface-point'
        }
        self._name = name
        self._uuid = uuid
        self._service_interface_point = service_interface_point

    @classmethod
    def from_dict(cls, dikt) -> 'TapiCommonTapiContext':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.common.TapiContext of this TapiCommonTapiContext.  # noqa: E501
        :rtype: TapiCommonTapiContext
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiCommonTapiContext.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiCommonTapiContext.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiCommonTapiContext.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiCommonTapiContext.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiCommonTapiContext.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiCommonTapiContext.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiCommonTapiContext.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiCommonTapiContext.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def service_interface_point(self) -> List[TapiCommonServiceInterfacePoint]:
        """Gets the service_interface_point of this TapiCommonTapiContext.

        none  # noqa: E501

        :return: The service_interface_point of this TapiCommonTapiContext.
        :rtype: List[TapiCommonServiceInterfacePoint]
        """
        return self._service_interface_point

    @service_interface_point.setter
    def service_interface_point(self, service_interface_point: List[TapiCommonServiceInterfacePoint]):
        """Sets the service_interface_point of this TapiCommonTapiContext.

        none  # noqa: E501

        :param service_interface_point: The service_interface_point of this TapiCommonTapiContext.
        :type service_interface_point: List[TapiCommonServiceInterfacePoint]
        """

        self._service_interface_point = service_interface_point
