# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from .mock_osm.MockOSM import MockOSM
from .Constants import SERVICE_CONNECTION_POINTS_1, SERVICE_CONNECTION_POINTS_2, SERVICE_TYPE
from .PrepareTestScenario import ( # pylint: disable=unused-import
    # be careful, order of symbols is important here!
    mock_service, compute_service_rest, osm_wim)

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)


def test_compute_create_connectivity_service_rest_api(osm_wim : MockOSM): # pylint: disable=redefined-outer-name
    osm_wim.create_connectivity_service(SERVICE_TYPE, SERVICE_CONNECTION_POINTS_1)

def test_compute_get_connectivity_service_status_rest_api(osm_wim : MockOSM): # pylint: disable=redefined-outer-name
    service_uuid = list(osm_wim.conn_info.keys())[0] # this test adds a single service
    osm_wim.get_connectivity_service_status(service_uuid)

def test_compute_edit_connectivity_service_rest_api(osm_wim : MockOSM): # pylint: disable=redefined-outer-name
    service_uuid = list(osm_wim.conn_info.keys())[0] # this test adds a single service
    osm_wim.edit_connectivity_service(service_uuid, SERVICE_CONNECTION_POINTS_2)

def test_compute_delete_connectivity_service_rest_api(osm_wim : MockOSM): # pylint: disable=redefined-outer-name
    service_uuid = list(osm_wim.conn_info.keys())[0] # this test adds a single service
    osm_wim.delete_connectivity_service(service_uuid)
