# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from flask import render_template, Blueprint, flash
from common.proto.context_pb2 import Empty
from load_generator.client.LoadGeneratorClient import LoadGeneratorClient

load_gen = Blueprint('load_gen', __name__, url_prefix='/load_gen')

@load_gen.route('start', methods=['GET'])
def start():
    load_gen_client = LoadGeneratorClient()
    try:
        load_gen_client.connect()
        load_gen_client.Start(Empty())
        load_gen_client.close()
        flash('Load Generator Started.', 'success')
    except Exception as e: # pylint: disable=broad-except
        flash('Problem starting Load Generator. {:s}'.format(str(e)), 'danger')

    return render_template('main/debug.html')

@load_gen.route('stop', methods=['GET'])
def stop():
    load_gen_client = LoadGeneratorClient()
    try:
        load_gen_client.connect()
        load_gen_client.Stop(Empty())
        load_gen_client.close()
        flash('Load Generator Stoped.', 'success')
    except Exception as e: # pylint: disable=broad-except
        flash('Problem stopping Load Generator. {:s}'.format(str(e)), 'danger')

    return render_template('main/debug.html')
