##### LLUIS GIFRE (CTTC): CODE UNDER REARRANGEMENT #####

# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from common.proto.context_pb2 import Empty
from common.proto.monitoring_pb2 import KpiDescriptorList
from common.tests.LoadScenario import load_scenario_from_descriptor
from context.client.ContextClient import ContextClient
from device.client.DeviceClient import DeviceClient
from monitoring.client.MonitoringClient import MonitoringClient
from tests.Fixtures import context_client, device_client, monitoring_client # pylint: disable=unused-import

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

DESCRIPTOR_FILE = 'ofc22/descriptors_emulated.json'

def test_scenario_empty(
    context_client : ContextClient, # pylint: disable=redefined-outer-name
    device_client : DeviceClient,   # pylint: disable=redefined-outer-name
) -> None:
    # ----- List entities - Ensure database is empty -------------------------------------------------------------------
    response = context_client.ListContexts(Empty())
    assert len(response.contexts) == 0

    response = context_client.ListDevices(Empty())
    assert len(response.devices) == 0

    response = context_client.ListLinks(Empty())
    assert len(response.links) == 0


    # ----- Load Scenario ----------------------------------------------------------------------------------------------
    load_scenario_from_descriptor(DESCRIPTOR_FILE, context_client, device_client, None, None)


    # ----- List entities - Ensure scenario is ready -------------------------------------------------------------------
    #response = context_client.ListContexts(Empty())
    #assert len(response.contexts) == len(CONTEXTS)

    #response = context_client.ListTopologies(ContextId(**CONTEXT_ID))
    #assert len(response.topologies) == len(TOPOLOGIES)

    #response = context_client.ListDevices(Empty())
    #assert len(response.devices) == len(DEVICES)

    #response = context_client.ListLinks(Empty())
    #assert len(response.links) == len(LINKS)

    #response = context_client.ListServices(ContextId(**CONTEXT_ID))
    #assert len(response.services) == 0


def test_scenario_kpis_created(monitoring_client: MonitoringClient):
    """
    This test validates that KPIs related to the service/device/endpoint were created
    during the service creation process.
    """
    response: KpiDescriptorList = monitoring_client.GetKpiDescriptorList(Empty())
    # TODO: replace the magic number `16` below for a formula that adapts to the number
    # of links and devices
    assert len(response.kpi_descriptor_list) >= 16
