# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import topology
class information_source_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/information-source-state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains state attributes related to the information
source.
  """
  __slots__ = ('_path_helper', '_extmethods', '__credibility_preference','__logical_network_element','__network_instance','__topology',)

  _yang_name = 'information-source-state'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__credibility_preference = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="credibility-preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)
    self.__logical_network_element = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-network-element", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    self.__network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    self.__topology = YANGDynClass(base=topology.topology, is_container='container', yang_name="topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'information-source-state']

  def _get_credibility_preference(self):
    """
    Getter method for credibility_preference, mapped from YANG variable /networks/network/link/te/information_source_state/credibility_preference (uint16)

    YANG Description: The preference value for calculating the Traffic
Engineering database credibility value used for
tie-break selection between different information-source
values.  A higher value is preferable.
    """
    return self.__credibility_preference
      
  def _set_credibility_preference(self, v, load=False):
    """
    Setter method for credibility_preference, mapped from YANG variable /networks/network/link/te/information_source_state/credibility_preference (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_credibility_preference is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_credibility_preference() directly.

    YANG Description: The preference value for calculating the Traffic
Engineering database credibility value used for
tie-break selection between different information-source
values.  A higher value is preferable.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="credibility-preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """credibility_preference must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="credibility-preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)""",
        })

    self.__credibility_preference = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_credibility_preference(self):
    self.__credibility_preference = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="credibility-preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=False)


  def _get_logical_network_element(self):
    """
    Getter method for logical_network_element, mapped from YANG variable /networks/network/link/te/information_source_state/logical_network_element (string)

    YANG Description: When applicable, this is the name of a logical network
element from which the information is learned.
    """
    return self.__logical_network_element
      
  def _set_logical_network_element(self, v, load=False):
    """
    Setter method for logical_network_element, mapped from YANG variable /networks/network/link/te/information_source_state/logical_network_element (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_network_element is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_network_element() directly.

    YANG Description: When applicable, this is the name of a logical network
element from which the information is learned.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="logical-network-element", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_network_element must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-network-element", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)""",
        })

    self.__logical_network_element = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_network_element(self):
    self.__logical_network_element = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-network-element", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)


  def _get_network_instance(self):
    """
    Getter method for network_instance, mapped from YANG variable /networks/network/link/te/information_source_state/network_instance (string)

    YANG Description: When applicable, this is the name of a network instance
from which the information is learned.
    """
    return self.__network_instance
      
  def _set_network_instance(self, v, load=False):
    """
    Setter method for network_instance, mapped from YANG variable /networks/network/link/te/information_source_state/network_instance (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_instance() directly.

    YANG Description: When applicable, this is the name of a network instance
from which the information is learned.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_instance must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)""",
        })

    self.__network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_instance(self):
    self.__network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)


  def _get_topology(self):
    """
    Getter method for topology, mapped from YANG variable /networks/network/link/te/information_source_state/topology (container)

    YANG Description: When the information is processed by the system,
the attributes in this container indicate which topology
is used to generate the result information.
    """
    return self.__topology
      
  def _set_topology(self, v, load=False):
    """
    Setter method for topology, mapped from YANG variable /networks/network/link/te/information_source_state/topology (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_topology is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_topology() directly.

    YANG Description: When the information is processed by the system,
the attributes in this container indicate which topology
is used to generate the result information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=topology.topology, is_container='container', yang_name="topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """topology must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=topology.topology, is_container='container', yang_name="topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__topology = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_topology(self):
    self.__topology = YANGDynClass(base=topology.topology, is_container='container', yang_name="topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  credibility_preference = __builtin__.property(_get_credibility_preference)
  logical_network_element = __builtin__.property(_get_logical_network_element)
  network_instance = __builtin__.property(_get_network_instance)
  topology = __builtin__.property(_get_topology)


  _pyangbind_elements = OrderedDict([('credibility_preference', credibility_preference), ('logical_network_element', logical_network_element), ('network_instance', network_instance), ('topology', topology), ])


