# 3.1. Configure VSCode and Connect to the VM


## 3.1.1. Install VSCode and the required extensions
If not already done, install [VSCode](https://code.visualstudio.com/) and the "Remote SSH" extension on your local
machine, not in the VM.

__Note__: "Python" extension is not required here. It will be installed later on the VSCode server running on the VM.


## 3.1.2. Configure the "Remote SSH" extension
- Go to left icon "Remote Explorer"
- Click the "gear" icon next to "SSH TARGETS" on top of "Remote Explorer" bar
- Choose to edit "<...>/.ssh/config" file (or equivalent)
- Add the following entry (assuming previous port forwarding configuration):
```
Host TFS-VM
    HostName 127.0.0.1
    Port 2200
    ForwardX11 no
    User tfs
```
- Save the file
- An entry "TFS-VM" should appear on "SSH TARGETS".


## 3.1.3. Connect VSCode to the VM through "Remote SSH" extension
- Right-click on "TFS-VM"
- Select "Connect to Host in Current Window"
- Reply to the questions asked
  - Platform of the remote host "TFS-VM": Linux
  - "TFS-VM" has fingerprint "<fingerprint>". Do you want to continue?: Continue
  - Type tfs user's password: tfs123
- You should be now connected to the TFS-VM.

__Note__: if you get a connection error message, the reason might be due to wrong SSH server fingerprint. Edit file
          "<...>/.ssh/known_hosts" on your local user account, check if there is a line starting with
          "[127.0.0.1]:2200" (assuming previous port forwarding configuration), remove the entire line, save the file,
          and retry connection.


## 3.1.4. Add SSH key to prevent typing the password every time
This step creates an SSH key in the VM and installs it on the VSCode to prevent having to type the password every time.

- In VSCode (connected to the VM), click menu "Terminal > New Terminal"
- Run the following commands on the VM's terminal through VSCode
```bash
ssh-keygen -t rsa -b 4096 -f ~/.ssh/tfs-vm.key
  # leave password empty
ssh-copy-id -i ~/.ssh/tfs-vm.key.pub tfs@10.0.2.10
  # tfs@10.0.2.10's password: <type tfs user's password: tfs123>
rm .ssh/known_hosts 
```

- In VSCode, click left "Explorer" panel to expand, if not expanded, and click "Open Folder" button.
  - Choose "/home/tfs/"
  - Type tfs user's password when asked
  - Trust authors of the "/home/tfs [SSH: TFS-VM]" folder when asked
- Right click on the file "tfs-vm.key" in the file explorer
  - Select "Download..." option
  - Download the file into your user's accout ".ssh" folder
- Delete files "tfs-vm.key" and "tfs-vm.key.pub" on the TFS-VM.

- In VSCode, click left "Remote Explorer" panel to expand
  - Click the "gear" icon next to "SSH TARGETS" on top of "Remote Explorer" bar
  - Choose to edit "<...>/.ssh/config" file (or equivalent)
  - Find entry "Host TFS-VM" and update it as follows:
```
Host TFS-VM
    HostName 127.0.0.1
    Port 2200
    ForwardX11 no
    User tfs
    IdentityFile "<path to the downloaded identity private key file>"
```
  - Save the file
- From now, VSCode will use the identity file to connect to the TFS-VM instead of the user's password.
