from copy import deepcopy
from device.proto.context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
from .Tools import config_rule_set, config_rule_delete

# use "deepcopy" to prevent propagating forced changes during tests

DEVICE_TAPI_UUID         = 'DEVICE-TAPI'
DEVICE_TAPI_TYPE         = 'optical-line-system'
DEVICE_TAPI_ADDRESS      = '0.0.0.0'
DEVICE_TAPI_PORT         = '4900'
DEVICE_TAPI_TIMEOUT      = '120'
DEVICE_TAPI_DRIVERS      = [DeviceDriverEnum.DEVICEDRIVER_TRANSPORT_API]

DEVICE_TAPI_ID = {'device_uuid': {'uuid': DEVICE_TAPI_UUID}}
DEVICE_TAPI = {
    'device_id': deepcopy(DEVICE_TAPI_ID),
    'device_type': DEVICE_TAPI_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_TAPI_DRIVERS,
    'device_endpoints': [],
}

DEVICE_TAPI_CONNECT_RULES = [
    config_rule_set('_connect/address',  DEVICE_TAPI_ADDRESS),
    config_rule_set('_connect/port',     DEVICE_TAPI_PORT),
    config_rule_set('_connect/timeout',  DEVICE_TAPI_TIMEOUT),
]

DEVICE_TAPI_CONFIG_RULES = [
    config_rule_set('network_instance[DemoOFC-NetInst]/interface[13/1/3]', {
        'name': 'DemoOFC-NetInst', 'id': '13/1/3',
    })
]

DEVICE_TAPI_DECONFIG_RULES = [
    config_rule_delete('network_instance[DemoOFC-NetInst]/interface[13/1/3]', {
        'name': 'DemoOFC-NetInst', 'id': '13/1/3'
    })
]