# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from sqlalchemy import Column, ForeignKey, ForeignKeyConstraint
from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from context.service.database.models._Base import _Base

LOGGER = logging.getLogger(__name__)

# class ConnectionSubServiceModel(Model):
#     pk = PrimaryKeyField()
#     connection_fk = ForeignKeyField(ConnectionModel)
#     sub_service_fk = ForeignKeyField(ServiceModel)


#    link_uuid = Column(UUID(as_uuid=False), ForeignKey("Link.link_uuid"))
#    endpoint_uuid = Column(UUID(as_uuid=False), ForeignKey("EndPoint.endpoint_uuid"), primary_key=True)

class LinkEndPointModel(_Base):
    __tablename__ = 'link_endpoint'
    link_uuid     = Column(UUID(as_uuid=False), primary_key=True)
    context_uuid  = Column(UUID(as_uuid=False), primary_key=True)
    topology_uuid = Column(UUID(as_uuid=False), primary_key=True)
    device_uuid   = Column(UUID(as_uuid=False), primary_key=True)
    endpoint_uuid = Column(UUID(as_uuid=False), primary_key=True)

    link     = relationship('LinkModel',     back_populates='link_endpoints', lazy='joined')
    endpoint = relationship('EndPointModel', back_populates='link_endpoints', lazy='joined')

    __table_args__ = (
        ForeignKeyConstraint(
            ['link_uuid'],
            ['link.link_uuid'],
            ondelete='CASCADE'),
        ForeignKeyConstraint(
            ['context_uuid', 'topology_uuid', 'device_uuid', 'endpoint_uuid'],
            ['endpoint.context_uuid', 'endpoint.topology_uuid', 'endpoint.device_uuid', 'endpoint.endpoint_uuid'],
            ondelete='CASCADE'),
    )

# class ServiceEndPointModel(Model):
#     pk = PrimaryKeyField()
#     service_fk = ForeignKeyField(ServiceModel)
#     endpoint_fk = ForeignKeyField(EndPointModel)

# class SliceEndPointModel(Model):
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     endpoint_fk = ForeignKeyField(EndPointModel)

# class SliceServiceModel(Model):
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     service_fk = ForeignKeyField(ServiceMo# pylint: disable=abstract-method
#     __tablename__ = 'LinkEndPoint'
#     uuid = Column(UUID(as_uuid=False), primary_key=True, unique=True)
#     link_uuid = Column(UUID(as_uuid=False), ForeignKey("Link.link_uuid"))
#     endpoint_uuid = Column(UUID(as_uuid=False), ForeignKey("EndPoint.endpoint_uuid"))
#del)

# class SliceSubSliceModel(Model):
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     sub_slice_fk = ForeignKeyField(SliceModel)

class TopologyDeviceModel(_Base):
    __tablename__ = 'topology_device'
    context_uuid  = Column(UUID(as_uuid=False), primary_key=True)
    topology_uuid = Column(UUID(as_uuid=False), primary_key=True)
    device_uuid   = Column(UUID(as_uuid=False), primary_key=True)

    topology = relationship('TopologyModel', back_populates='topology_devices', lazy='joined')
    device   = relationship('DeviceModel',   back_populates='topology_devices', lazy='joined')

    __table_args__ = (
        ForeignKeyConstraint(
            ['context_uuid', 'topology_uuid'],
            ['topology.context_uuid', 'topology.topology_uuid'],
            ondelete='CASCADE'),
        ForeignKeyConstraint(
            ['device_uuid'],
            ['device.device_uuid'],
            ondelete='CASCADE'),
    )

class TopologyLinkModel(_Base):
    __tablename__ = 'topology_link'
    context_uuid  = Column(UUID(as_uuid=False), primary_key=True)
    topology_uuid = Column(UUID(as_uuid=False), primary_key=True)
    link_uuid     = Column(UUID(as_uuid=False), primary_key=True)

    topology = relationship('TopologyModel', back_populates='topology_links', lazy='joined')
    link     = relationship('LinkModel',     back_populates='topology_links', lazy='joined')

    __table_args__ = (
        ForeignKeyConstraint(
            ['context_uuid', 'topology_uuid'],
            ['topology.context_uuid', 'topology.topology_uuid'],
            ondelete='CASCADE'),
        ForeignKeyConstraint(
            ['link_uuid'],
            ['link.link_uuid'],
            ondelete='CASCADE'),
    )
