# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import copy, grpc, pytest
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from common.proto.context_pb2 import Context, ContextId, Topology, TopologyId
from context.client.ContextClient import ContextClient
#from context.client.EventsCollector import EventsCollector
from .Objects import CONTEXT, CONTEXT_ID, TOPOLOGY, TOPOLOGY_ID

def grpc_topology(context_client_grpc : ContextClient) -> None:

    # ----- Initialize the EventsCollector -----------------------------------------------------------------------------
    #events_collector = EventsCollector(
    #    context_client_grpc, log_events_received=True,
    #    activate_context_collector = False, activate_topology_collector = True, activate_device_collector = False,
    #    activate_link_collector = False, activate_service_collector = False, activate_slice_collector = False,
    #    activate_connection_collector = False)
    #events_collector.start()

    # ----- Prepare dependencies for the test and capture related events -----------------------------------------------
    response = context_client_grpc.SetContext(Context(**CONTEXT))
    assert response.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    # event = events_collector.get_event(block=True)
    # assert isinstance(event, ContextEvent)
    # assert event.event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    # assert event.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID

    # ----- Get when the object does not exist -------------------------------------------------------------------------
    with pytest.raises(grpc.RpcError) as e:
        context_client_grpc.GetTopology(TopologyId(**TOPOLOGY_ID))
    assert e.value.code() == grpc.StatusCode.NOT_FOUND
    assert e.value.details() == 'Topology({:s}/{:s}) not found'.format(DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID)

    # ----- List when the object does not exist ------------------------------------------------------------------------
    response = context_client_grpc.ListTopologyIds(ContextId(**CONTEXT_ID))
    assert len(response.topology_ids) == 0

    response = context_client_grpc.ListTopologies(ContextId(**CONTEXT_ID))
    assert len(response.topologies) == 0

    # ----- Create the object ------------------------------------------------------------------------------------------
    response = context_client_grpc.SetTopology(Topology(**TOPOLOGY))
    assert response.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    #CONTEXT_WITH_TOPOLOGY = copy.deepcopy(CONTEXT)
    #CONTEXT_WITH_TOPOLOGY['topology_ids'].append(TOPOLOGY_ID)
    #response = context_client_grpc.SetContext(Context(**CONTEXT_WITH_TOPOLOGY))
    #assert response.context_uuid.uuid == DEFAULT_CONTEXT_UUID

    # ----- Check create event -----------------------------------------------------------------------------------------
    #events = events_collector.get_events(block=True, count=2)
    #assert isinstance(events[0], TopologyEvent)
    #assert events[0].event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    #assert events[0].topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    #assert events[0].topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    #assert isinstance(events[1], ContextEvent)
    #assert events[1].event.event_type == EventTypeEnum.EVENTTYPE_UPDATE
    #assert events[1].context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID

    # ----- Get when the object exists ---------------------------------------------------------------------------------
    response = context_client_grpc.GetContext(ContextId(**CONTEXT_ID))
    assert response.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.name == ''
    assert len(response.topology_ids) == 1
    assert response.topology_ids[0].context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_ids[0].topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    assert len(response.service_ids) == 0
    assert len(response.slice_ids) == 0

    response = context_client_grpc.GetTopology(TopologyId(**TOPOLOGY_ID))
    assert response.topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    assert response.name == ''
    assert len(response.device_ids) == 0
    assert len(response.link_ids) == 0

    # ----- List when the object exists --------------------------------------------------------------------------------
    response = context_client_grpc.ListTopologyIds(ContextId(**CONTEXT_ID))
    assert len(response.topology_ids) == 1
    assert response.topology_ids[0].context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_ids[0].topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    response = context_client_grpc.ListTopologies(ContextId(**CONTEXT_ID))
    assert len(response.topologies) == 1
    assert response.topologies[0].topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topologies[0].topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    assert response.topologies[0].name == ''
    assert len(response.topologies[0].device_ids) == 0
    assert len(response.topologies[0].link_ids) == 0

    # ----- Update the object ------------------------------------------------------------------------------------------
    new_topology_name = 'new'
    TOPOLOGY_WITH_NAME = copy.deepcopy(TOPOLOGY)
    TOPOLOGY_WITH_NAME['name'] = new_topology_name
    response = context_client_grpc.SetTopology(Topology(**TOPOLOGY_WITH_NAME))
    assert response.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    # ----- Check update event -----------------------------------------------------------------------------------------
    #event = events_collector.get_event(block=True)
    #assert isinstance(event, TopologyEvent)
    #assert event.event.event_type == EventTypeEnum.EVENTTYPE_UPDATE
    #assert event.topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    #assert event.topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    # ----- Get when the object is modified ----------------------------------------------------------------------------
    response = context_client_grpc.GetTopology(TopologyId(**TOPOLOGY_ID))
    assert response.topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    assert response.name == new_topology_name
    assert len(response.device_ids) == 0
    assert len(response.link_ids) == 0

    # ----- List when the object is modified ---------------------------------------------------------------------------
    response = context_client_grpc.ListTopologyIds(ContextId(**CONTEXT_ID))
    assert len(response.topology_ids) == 1
    assert response.topology_ids[0].context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_ids[0].topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    response = context_client_grpc.ListTopologies(ContextId(**CONTEXT_ID))
    assert len(response.topologies) == 1
    assert response.topologies[0].topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topologies[0].topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    assert response.topologies[0].name == new_topology_name
    assert len(response.topologies[0].device_ids) == 0
    assert len(response.topologies[0].link_ids) == 0

    # ----- Remove the object ------------------------------------------------------------------------------------------
    context_client_grpc.RemoveTopology(TopologyId(**TOPOLOGY_ID))

    # ----- Check remove event -----------------------------------------------------------------------------------------
    #event = events_collector.get_event(block=True)
    #assert isinstance(event, TopologyEvent)
    #assert event.event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    #assert event.topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    #assert event.topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    # ----- List after deleting the object -----------------------------------------------------------------------------
    response = context_client_grpc.ListTopologyIds(ContextId(**CONTEXT_ID))
    assert len(response.topology_ids) == 0

    response = context_client_grpc.ListTopologies(ContextId(**CONTEXT_ID))
    assert len(response.topologies) == 0

    # ----- Clean dependencies used in the test and capture related events ---------------------------------------------
    context_client_grpc.RemoveContext(ContextId(**CONTEXT_ID))
    #event = events_collector.get_event(block=True)
    #assert isinstance(event, ContextEvent)
    #assert event.event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    #assert event.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID

    # ----- Stop the EventsCollector -----------------------------------------------------------------------------------
    #events_collector.stop()
