# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import copy, grpc, pytest
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from common.proto.context_pb2 import Context, ContextId, Device, DeviceId, Empty, Link, LinkId, Topology, TopologyId
from context.client.ContextClient import ContextClient
#from context.client.EventsCollector import EventsCollector
from .Objects import (
    CONTEXT, CONTEXT_ID, DEVICE_R1, DEVICE_R1_ID, DEVICE_R1_UUID, DEVICE_R2, DEVICE_R2_ID, DEVICE_R2_UUID, LINK_R1_R2,
    LINK_R1_R2_ID, LINK_R1_R2_UUID, TOPOLOGY, TOPOLOGY_ID)

def grpc_link(context_client_grpc: ContextClient) -> None:

    # ----- Initialize the EventsCollector -----------------------------------------------------------------------------
    #events_collector = EventsCollector(
    #    context_client_grpc, log_events_received=True,
    #    activate_context_collector = False, activate_topology_collector = False, activate_device_collector = False,
    #    activate_link_collector = True, activate_service_collector = False, activate_slice_collector = False,
    #    activate_connection_collector = False)
    #events_collector.start()

    # ----- Prepare dependencies for the test and capture related events -----------------------------------------------
    response = context_client_grpc.SetContext(Context(**CONTEXT))
    assert response.context_uuid.uuid == DEFAULT_CONTEXT_UUID

    response = context_client_grpc.SetTopology(Topology(**TOPOLOGY))
    assert response.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    response = context_client_grpc.SetDevice(Device(**DEVICE_R1))
    assert response.device_uuid.uuid == DEVICE_R1_UUID

    response = context_client_grpc.SetDevice(Device(**DEVICE_R2))
    assert response.device_uuid.uuid == DEVICE_R2_UUID

    # events = events_collector.get_events(block=True, count=4)
    # assert isinstance(events[0], ContextEvent)
    # assert events[0].event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    # assert events[0].context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    # assert isinstance(events[1], TopologyEvent)
    # assert events[1].event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    # assert events[1].topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    # assert events[1].topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    # assert isinstance(events[2], DeviceEvent)
    # assert events[2].event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    # assert events[2].device_id.device_uuid.uuid == DEVICE_R1_UUID
    # assert isinstance(events[3], DeviceEvent)
    # assert events[3].event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    # assert events[3].device_id.device_uuid.uuid == DEVICE_R2_UUID

    # ----- Get when the object does not exist -------------------------------------------------------------------------
    with pytest.raises(grpc.RpcError) as e:
        context_client_grpc.GetLink(LinkId(**LINK_R1_R2_ID))
    assert e.value.code() == grpc.StatusCode.NOT_FOUND
    assert e.value.details() == 'Link({:s}) not found'.format(LINK_R1_R2_UUID)

    # ----- List when the object does not exist ------------------------------------------------------------------------
    response = context_client_grpc.ListLinkIds(Empty())
    assert len(response.link_ids) == 0

    response = context_client_grpc.ListLinks(Empty())
    assert len(response.links) == 0

    # ----- Create the object ------------------------------------------------------------------------------------------
    response = context_client_grpc.SetLink(Link(**LINK_R1_R2))
    assert response.link_uuid.uuid == LINK_R1_R2_UUID

    # ----- Check create event -----------------------------------------------------------------------------------------
    # event = events_collector.get_event(block=True)
    # assert isinstance(event, LinkEvent)
    # assert event.event.event_type == EventTypeEnum.EVENTTYPE_CREATE
    # assert event.link_id.link_uuid.uuid == LINK_R1_R2_UUID

    # ----- Get when the object exists ---------------------------------------------------------------------------------
    response = context_client_grpc.GetLink(LinkId(**LINK_R1_R2_ID))
    assert response.link_id.link_uuid.uuid == LINK_R1_R2_UUID
    assert response.name == ''
    assert len(response.link_endpoint_ids) == 2

    # ----- List when the object exists --------------------------------------------------------------------------------
    response = context_client_grpc.ListLinkIds(Empty())
    assert len(response.link_ids) == 1
    assert response.link_ids[0].link_uuid.uuid == LINK_R1_R2_UUID

    response = context_client_grpc.ListLinks(Empty())
    assert len(response.links) == 1
    assert response.links[0].link_id.link_uuid.uuid == LINK_R1_R2_UUID
    assert response.links[0].name == ''
    assert len(response.links[0].link_endpoint_ids) == 2

    # ----- Update the object ------------------------------------------------------------------------------------------
    new_link_name = 'l1'
    LINK_UPDATED = copy.deepcopy(LINK_R1_R2)
    LINK_UPDATED['name'] = new_link_name
    response = context_client_grpc.SetLink(Link(**LINK_UPDATED))
    assert response.link_uuid.uuid == LINK_R1_R2_UUID

    # ----- Check update event -----------------------------------------------------------------------------------------
    # event = events_collector.get_event(block=True)
    # assert isinstance(event, LinkEvent)
    # assert event.event.event_type == EventTypeEnum.EVENTTYPE_UPDATE
    # assert event.link_id.link_uuid.uuid == LINK_R1_R2_UUID

    # ----- Get when the object is modified ----------------------------------------------------------------------------
    response = context_client_grpc.GetLink(LinkId(**LINK_R1_R2_ID))
    assert response.link_id.link_uuid.uuid == LINK_R1_R2_UUID
    assert response.name == new_link_name
    assert len(response.link_endpoint_ids) == 2

    # ----- List when the object is modified ---------------------------------------------------------------------------
    response = context_client_grpc.ListLinkIds(Empty())
    assert len(response.link_ids) == 1
    assert response.link_ids[0].link_uuid.uuid == LINK_R1_R2_UUID

    response = context_client_grpc.ListLinks(Empty())
    assert len(response.links) == 1
    assert response.links[0].link_id.link_uuid.uuid == LINK_R1_R2_UUID
    assert response.links[0].name == new_link_name
    assert len(response.links[0].link_endpoint_ids) == 2

    # ----- Create object relation -------------------------------------------------------------------------------------
    TOPOLOGY_WITH_LINK = copy.deepcopy(TOPOLOGY)
    TOPOLOGY_WITH_LINK['link_ids'].append(LINK_R1_R2_ID)
    response = context_client_grpc.SetTopology(Topology(**TOPOLOGY_WITH_LINK))
    assert response.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    # ----- Check update event -----------------------------------------------------------------------------------------
    # event = events_collector.get_event(block=True)
    # assert isinstance(event, TopologyEvent)
    # assert event.event.event_type == EventTypeEnum.EVENTTYPE_UPDATE
    # assert response.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    # assert response.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID

    # ----- Check relation was created ---------------------------------------------------------------------------------
    response = context_client_grpc.GetTopology(TopologyId(**TOPOLOGY_ID))
    assert response.topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    assert response.topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    assert len(response.device_ids) == 2
    assert response.device_ids[0].device_uuid.uuid in {DEVICE_R1_UUID, DEVICE_R2_UUID}
    assert response.device_ids[1].device_uuid.uuid in {DEVICE_R1_UUID, DEVICE_R2_UUID}
    assert len(response.link_ids) == 1
    assert response.link_ids[0].link_uuid.uuid == LINK_R1_R2_UUID

    # ----- Remove the object ------------------------------------------------------------------------------------------
    #context_client_grpc.RemoveLink(LinkId(**LINK_R1_R2_ID))
    #context_client_grpc.RemoveDevice(DeviceId(**DEVICE_R1_ID))
    #context_client_grpc.RemoveDevice(DeviceId(**DEVICE_R2_ID))
    #context_client_grpc.RemoveTopology(TopologyId(**TOPOLOGY_ID))
    #context_client_grpc.RemoveContext(ContextId(**CONTEXT_ID))

    # ----- Check remove event -----------------------------------------------------------------------------------------
    # events = events_collector.get_events(block=True, count=5)
    #
    # assert isinstance(events[0], LinkEvent)
    # assert events[0].event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    # assert events[0].link_id.link_uuid.uuid == LINK_R1_R2_UUID
    #
    # assert isinstance(events[1], DeviceEvent)
    # assert events[1].event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    # assert events[1].device_id.device_uuid.uuid == DEVICE_R1_UUID
    #
    # assert isinstance(events[2], DeviceEvent)
    # assert events[2].event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    # assert events[2].device_id.device_uuid.uuid == DEVICE_R2_UUID
    #
    # assert isinstance(events[3], TopologyEvent)
    # assert events[3].event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    # assert events[3].topology_id.context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID
    # assert events[3].topology_id.topology_uuid.uuid == DEFAULT_TOPOLOGY_UUID
    #
    # assert isinstance(events[4], ContextEvent)
    # assert events[4].event.event_type == EventTypeEnum.EVENTTYPE_REMOVE
    # assert events[4].context_id.context_uuid.uuid == DEFAULT_CONTEXT_UUID

    # ----- Stop the EventsCollector -----------------------------------------------------------------------------------
    #events_collector.stop()
