/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.oregon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.sourceforge.plantuml.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagicTable {
    private final Oc[] number = new Oc[10000];
    private static ArrayList<int[]> neighboors = new ArrayList();

    public static int[] getNeighboors(int n) {
        if (neighboors.get(n) == null) {
            neighboors.set(n, MagicTable.getNeighboorsSlow(n));
        }
        return neighboors.get(n);
    }

    public static int[] getNeighboorsSlow(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[36];
        int n6 = n % 10;
        int n7 = n - n6;
        int n8 = 0;
        for (n5 = 0; n5 < 10; ++n5) {
            n4 = n7 + n5;
            if (n4 == n) continue;
            nArray[n8++] = n4;
        }
        n5 = n / 10 % 10;
        n7 = n - n5 * 10;
        for (n4 = 0; n4 < 10; ++n4) {
            n3 = n7 + n4 * 10;
            if (n3 == n) continue;
            nArray[n8++] = n3;
        }
        n4 = n / 100 % 10;
        n7 = n - n4 * 100;
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = n7 + n3 * 100;
            if (n2 == n) continue;
            nArray[n8++] = n2;
        }
        n3 = n / 1000;
        n7 = n - n3 * 1000;
        for (n2 = 0; n2 < 10; ++n2) {
            int n9 = n7 + n2 * 1000;
            if (n9 == n) continue;
            nArray[n8++] = n9;
        }
        return nArray;
    }

    public List<Integer> getAllFree() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10000);
        for (int i = 0; i < this.number.length; ++i) {
            if (this.number[i] != null) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public List<Integer> getAllUsed() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10000);
        for (int i = 0; i < this.number.length; ++i) {
            if (this.number[i] != Oc.USED) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public boolean isUsuable(int n) {
        if (this.number[n] != null) {
            return false;
        }
        for (int n2 : MagicTable.getNeighboors(n)) {
            if (this.number[n2] == null) continue;
            return false;
        }
        return true;
    }

    public void burnNumber(int n) {
        if (this.number[n] != null) {
            throw new IllegalArgumentException();
        }
        this.number[n] = Oc.USED;
        for (int n2 : MagicTable.getNeighboors(n)) {
            this.number[n2] = Oc.NEAR;
        }
    }

    public int getRandomFree(Random random) {
        List<Integer> list = this.getAllFree();
        Collections.shuffle(list, random);
        for (int n : list) {
            if (!this.isUsuable(n)) continue;
            return n;
        }
        return -1;
    }

    public static int size(Random random, MagicTable magicTable) {
        int n;
        int n2 = 0;
        while ((n = magicTable.getRandomFree(random)) != -1) {
            magicTable.burnNumber(n);
            ++n2;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        long l = System.currentTimeMillis();
        Random random = new Random(49L);
        for (int i = 0; i < 200000; ++i) {
            MagicTable magicTable;
            int n2;
            if (i == 100) {
                long l2 = (System.currentTimeMillis() - l) / 1000L;
                l2 = l2 * 200000L / 100L;
                Log.println("Estimated duration = " + (l2 /= 3600L) + " h");
            }
            if ((n2 = MagicTable.size(random, magicTable = new MagicTable())) <= n) continue;
            Log.println("v=" + n2);
            Log.println("mt=" + magicTable.getAllUsed());
            n = n2;
        }
        long l3 = System.currentTimeMillis() - l;
        Log.println("Duration = " + l3 / 1000L / 60L);
    }

    public static void main2(String[] stringArray) {
        int n = 0;
        long l = System.currentTimeMillis();
        for (int i = 1; i < 100; ++i) {
            Random random = new Random(i);
            for (int j = 0; j < 1000; ++j) {
                MagicTable magicTable = new MagicTable();
                int n2 = MagicTable.size(random, magicTable);
                if (n2 <= n) continue;
                Log.println("v=" + n2);
                Log.println("mt=" + magicTable.getAllUsed());
                n = n2;
            }
        }
        long l2 = System.currentTimeMillis() - l;
        Log.println("Duration = " + l2 / 1000L / 60L);
    }

    static {
        for (int i = 0; i < 10000; ++i) {
            neighboors.add(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Oc {
        USED,
        NEAR;

    }
}

