/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Properties;
import jcckit.graphic.BasicGraphicAttributes;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.ShapeAttributes;
import jcckit.graphic.TextAttributes;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.ConfigParametersBasedConfigData;
import jcckit.util.Factory;
import jcckit.util.Format;
import jcckit.util.PropertiesBasedConfigData;
import jcckit.util.TicLabelFormat;
import jcckit.util.Util;

public class AxisParameters {
    public static final String LOG_SCALE_KEY = "logScale";
    public static final String MINIMUM_KEY = "minimum";
    public static final String MAXIMUM_KEY = "maximum";
    public static final String AXIS_LENGTH_KEY = "axisLength";
    public static final String AXIS_ATTRIBUTES_KEY = "axisAttributes";
    public static final String AXIS_LABEL_KEY = "axisLabel";
    public static final String AXIS_LABEL_POSITION_KEY = "axisLabelPosition";
    public static final String AXIS_LABEL_ATTRIBUTES_KEY = "axisLabelAttributes";
    public static final String AUTOMATIC_TIC_CALCULATION_KEY = "automaticTicCalculation";
    public static final String MINIMUM_TIC_KEY = "minimumTic";
    public static final String MAXIMUM_TIC_KEY = "maximumTic";
    public static final String NUMBER_OF_TICS_KEY = "numberOfTics";
    public static final String TIC_LENGTH_KEY = "ticLength";
    public static final String TIC_ATTRIBUTES_KEY = "ticAttributes";
    public static final String TIC_LABEL_FORMAT_KEY = "ticLabelFormat";
    public static final String TIC_LABEL_POSITION_KEY = "ticLabelPosition";
    public static final String TIC_LABEL_ATTRIBUTES_KEY = "ticLabelAttributes";
    public static final String GRID_KEY = "grid";
    public static final String GRID_ATTRIBUTES_KEY = "gridAttributes";
    private static final double LN10 = Math.log(10.0);
    boolean logScale;
    double minimum;
    double maximum;
    double axisLength;
    LineAttributes axisAttributes;
    boolean automaticTicCalculation;
    double minimumTic;
    double maximumTic;
    int numberOfTics;
    double ticLength;
    LineAttributes ticAttributes;
    TicLabelFormat ticLabelFormat;
    GraphPoint ticLabelPosition;
    TextAttributes ticLabelAttributes;
    boolean grid;
    LineAttributes gridAttributes;
    String axisLabel;
    GraphPoint axisLabelPosition;
    TextAttributes axisLabelAttributes;

    double[] calculateTics() {
        if (this.automaticTicCalculation) {
            this.calculateTicsParameters();
        }
        double[] dArray = new double[this.numberOfTics];
        if (this.numberOfTics > 0) {
            double d = Util.log(this.minimumTic, this.logScale);
            double d2 = Util.log(this.maximumTic, this.logScale);
            d2 = this.numberOfTics > 1 ? (d2 - d) / (double)(this.numberOfTics - 1) : 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = Util.exp(d2 * (double)i + d, this.logScale);
            }
            dArray[0] = AxisParameters.adjust(this.minimum, dArray[0]);
            dArray[this.numberOfTics - 1] = AxisParameters.adjust(this.maximum, dArray[this.numberOfTics - 1]);
        }
        return dArray;
    }

    private void calculateTicsParameters() {
        double d = Math.min(this.minimum, this.maximum);
        double d2 = Math.max(this.minimum, this.maximum);
        if (this.logScale) {
            int n = (int)(199.9999 + Math.log(d) / LN10) - 199;
            int n2 = (int)(200.0001 + Math.log(d2) / LN10) - 200;
            this.minimumTic = Math.exp(LN10 * (double)n);
            this.maximumTic = Math.exp(LN10 * (double)n2);
            this.numberOfTics = n2 - n + 1;
        } else {
            int n = (int)(199.69 + Math.log(d2 - d) / LN10) - 200;
            double d3 = 0.2 * Math.exp(LN10 * (double)n);
            do {
                int n3 = (int)(999999.999999 + d / (d3 *= 5.0)) - 999999;
                int n4 = (int)(1000000.000001 + d2 / d3) - 1000000;
                this.minimumTic = (double)n3 * d3;
                this.maximumTic = (double)n4 * d3;
                this.numberOfTics = n4 - n3 + 1;
            } while (this.numberOfTics > 11);
        }
    }

    private static double adjust(double d, double d2) {
        return d2 != 0.0 && Math.abs(d / d2 - 1.0) < 1.0E-11 ? d : d2;
    }

    private static Properties createDefaultAxisProperties() {
        Properties properties = new Properties();
        properties.put(LOG_SCALE_KEY, "false");
        properties.put(MINIMUM_KEY, "0");
        properties.put(MAXIMUM_KEY, "1");
        properties.put(AXIS_LENGTH_KEY, "0.8");
        properties.put("axisAttributes/className", ShapeAttributes.class.getName());
        properties.put(AXIS_LABEL_KEY, "x");
        properties.put(AXIS_LABEL_POSITION_KEY, "0 -0.05");
        properties.put("axisLabelAttributes/className", BasicGraphicAttributes.class.getName());
        properties.put("axisLabelAttributes/horizontalAnchor", "center");
        properties.put(AUTOMATIC_TIC_CALCULATION_KEY, "true");
        properties.put(TIC_LENGTH_KEY, "0.01");
        properties.put("ticAttributes/className", ShapeAttributes.class.getName());
        properties.put(TIC_LABEL_POSITION_KEY, "0 -0.01");
        properties.put(TIC_LABEL_FORMAT_KEY, "%1.1f");
        properties.put("ticLabelAttributes/className", BasicGraphicAttributes.class.getName());
        properties.put("ticLabelAttributes/horizontalAnchor", "center");
        properties.put("ticLabelAttributes/verticalAnchor", "top");
        properties.put(GRID_KEY, "false");
        properties.put("gridAttributes/className", ShapeAttributes.class.getName());
        return properties;
    }

    private static Properties createDefaultXAxisProperties() {
        Properties properties = AxisParameters.createDefaultAxisProperties();
        properties.put(AXIS_LABEL_KEY, "x");
        properties.put(AXIS_LABEL_POSITION_KEY, "0 -0.05");
        properties.put("axisLabelAttributes/verticalAnchor", "top");
        properties.put(TIC_LABEL_POSITION_KEY, "0 -0.01");
        properties.put("ticLabelAttributes/horizontalAnchor", "center");
        properties.put("ticLabelAttributes/verticalAnchor", "top");
        return properties;
    }

    public static AxisParameters createXAxis(ConfigParameters configParameters) {
        return AxisParameters.createAxis(configParameters, AxisParameters.createDefaultXAxisProperties());
    }

    private static Properties createDefaultYAxisProperties() {
        Properties properties = AxisParameters.createDefaultAxisProperties();
        properties.put(AXIS_LENGTH_KEY, "0.45");
        properties.put(AXIS_LABEL_KEY, "y");
        properties.put(AXIS_LABEL_POSITION_KEY, "-0.1 0");
        properties.put("axisLabelAttributes/verticalAnchor", "bottom");
        properties.put("axisLabelAttributes/orientationAngle", "90");
        properties.put(TIC_LABEL_POSITION_KEY, "-0.01 0");
        properties.put("ticLabelAttributes/horizontalAnchor", "right");
        properties.put("ticLabelAttributes/verticalAnchor", "center");
        return properties;
    }

    public static AxisParameters createYAxis(ConfigParameters configParameters) {
        return AxisParameters.createAxis(configParameters, AxisParameters.createDefaultYAxisProperties());
    }

    private static AxisParameters createAxis(ConfigParameters configParameters, Properties properties) {
        ConfigData configData = new PropertiesBasedConfigData(properties);
        ConfigParameters configParameters2 = new ConfigParameters(configData);
        configData = new ConfigParametersBasedConfigData(configParameters, configParameters2);
        configParameters2 = new ConfigParameters(configData);
        AxisParameters axisParameters = new AxisParameters();
        axisParameters.logScale = configParameters2.getBoolean(LOG_SCALE_KEY);
        axisParameters.minimum = configParameters2.getDouble(MINIMUM_KEY);
        axisParameters.maximum = configParameters2.getDouble(MAXIMUM_KEY);
        axisParameters.axisLength = configParameters2.getDouble(AXIS_LENGTH_KEY);
        axisParameters.axisAttributes = (LineAttributes)Factory.create(configParameters2.getNode(AXIS_ATTRIBUTES_KEY));
        axisParameters.axisLabel = configParameters2.get(AXIS_LABEL_KEY);
        axisParameters.axisLabelPosition = new GraphPoint(configParameters2.getDoubleArray(AXIS_LABEL_POSITION_KEY));
        axisParameters.axisLabelAttributes = (TextAttributes)Factory.create(configParameters2.getNode(AXIS_LABEL_ATTRIBUTES_KEY));
        axisParameters.ticLength = configParameters2.getDouble(TIC_LENGTH_KEY);
        axisParameters.automaticTicCalculation = configParameters2.getBoolean(AUTOMATIC_TIC_CALCULATION_KEY);
        if (!axisParameters.automaticTicCalculation) {
            axisParameters.calculateTicsParameters();
            axisParameters.minimumTic = configParameters2.getDouble(MINIMUM_TIC_KEY, axisParameters.minimumTic);
            axisParameters.maximumTic = configParameters2.getDouble(MAXIMUM_TIC_KEY, axisParameters.maximumTic);
            axisParameters.numberOfTics = configParameters2.getInt(NUMBER_OF_TICS_KEY, axisParameters.numberOfTics);
        }
        axisParameters.ticAttributes = (LineAttributes)Factory.create(configParameters2.getNode(TIC_ATTRIBUTES_KEY));
        axisParameters.ticLabelFormat = AxisParameters.createTicLabelFormat(configParameters2);
        axisParameters.ticLabelPosition = new GraphPoint(configParameters2.getDoubleArray(TIC_LABEL_POSITION_KEY));
        axisParameters.ticLabelAttributes = (TextAttributes)Factory.create(configParameters2.getNode(TIC_LABEL_ATTRIBUTES_KEY));
        axisParameters.grid = configParameters2.getBoolean(GRID_KEY);
        axisParameters.gridAttributes = (LineAttributes)Factory.create(configParameters2.getNode(GRID_ATTRIBUTES_KEY));
        return axisParameters;
    }

    private static TicLabelFormat createTicLabelFormat(ConfigParameters configParameters) {
        TicLabelFormat ticLabelFormat = Format.create(configParameters, TIC_LABEL_FORMAT_KEY);
        ConfigParameters configParameters2 = configParameters.getNode(TIC_LABEL_FORMAT_KEY);
        if (configParameters2.get("className", null) != null) {
            ticLabelFormat = (TicLabelFormat)Factory.create(configParameters2);
        }
        return ticLabelFormat;
    }
}

