# Ref: https://www.cockroachlabs.com/docs/stable/configure-cockroachdb-kubernetes.html

DEPLOY_PATH="manifests/cockroachdb"
OPERATOR_BASE_URL="https://raw.githubusercontent.com/cockroachdb/cockroach-operator/master"

mkdir -p ${DEPLOY_PATH}

# Apply Custom Resource Definition for the CockroachDB Operator
curl -o "${DEPLOY_PATH}/crds.yaml" "${OPERATOR_BASE_URL}/install/crds.yaml"
kubectl apply -f "${DEPLOY_PATH}/crds.yaml"

# Deploy CockroachDB Operator
curl -o "${DEPLOY_PATH}/operator.yaml" "${OPERATOR_BASE_URL}/install/operator.yaml"
# edit "${DEPLOY_PATH}/operator.yaml"
# - add env var: WATCH_NAMESPACE='crdb'
kubectl apply -f "${DEPLOY_PATH}/operator.yaml"

# Deploy CockroachDB
curl -o "${DEPLOY_PATH}/cluster.yaml" "${OPERATOR_BASE_URL}/examples/example.yaml"
# edit "${DEPLOY_PATH}/cluster.yaml"
# - set version
# - set number of replicas
kubectl create namespace crdb
kubectl apply --namespace crdb -f "${DEPLOY_PATH}/cluster.yaml"

# Deploy CockroachDB Client
curl -o "${DEPLOY_PATH}/client-secure-operator.yaml" "${OPERATOR_BASE_URL}/examples/client-secure-operator.yaml"
kubectl create --namespace crdb -f "${DEPLOY_PATH}/client-secure-operator.yaml"

# Add tfs user with admin rights
kubectl exec -it cockroachdb-client-secure --namespace crdb -- ./cockroach sql --certs-dir=/cockroach/cockroach-certs --host=cockroachdb-public
    CREATE USER tfs WITH PASSWORD 'tfs123';
    GRANT admin TO tfs;

# Expose CockroachDB SQL port (26257)
PORT=$(kubectl --namespace crdb get service cockroachdb-public -o 'jsonpath={.spec.ports[?(@.name=="sql")].port}')
PATCH='{"data": {"'${PORT}'": "crdb/cockroachdb-public:'${PORT}'"}}'
kubectl patch configmap nginx-ingress-tcp-microk8s-conf --namespace ingress --patch "${PATCH}"

PORT_MAP='{"containerPort": '${PORT}', "hostPort": '${PORT}'}'
CONTAINER='{"name": "nginx-ingress-microk8s", "ports": ['${PORT_MAP}']}'
PATCH='{"spec": {"template": {"spec": {"containers": ['${CONTAINER}']}}}}'
kubectl patch daemonset nginx-ingress-microk8s-controller --namespace ingress --patch "${PATCH}"

# Expose CockroachDB Console port (8080)
PORT=$(kubectl --namespace crdb get service cockroachdb-public -o 'jsonpath={.spec.ports[?(@.name=="http")].port}')
PATCH='{"data": {"'${PORT}'": "crdb/cockroachdb-public:'${PORT}'"}}'
kubectl patch configmap nginx-ingress-tcp-microk8s-conf --namespace ingress --patch "${PATCH}"

PORT_MAP='{"containerPort": '${PORT}', "hostPort": '${PORT}'}'
CONTAINER='{"name": "nginx-ingress-microk8s", "ports": ['${PORT_MAP}']}'
PATCH='{"spec": {"template": {"spec": {"containers": ['${CONTAINER}']}}}}'
kubectl patch daemonset nginx-ingress-microk8s-controller --namespace ingress --patch "${PATCH}"
