#!/bin/bash

PROJECTDIR=`pwd`

cd $(dirname $0)/src
RCFILE=$PROJECTDIR/coverage/.coveragerc
COVERAGEFILE=$PROJECTDIR/coverage/.coverage

# configure the correct folder on the .coveragerc file
cat $PROJECTDIR/coverage/.coveragerc.template | sed s+~/teraflow/controller+$PROJECTDIR+g > $RCFILE

# Run unitary tests and analyze coverage of code at same time

# First destroy old coverage file
rm -f $COVERAGEFILE

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    common/metrics/tests/test_unitary.py \
    common/orm/tests/test_unitary.py

#coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
#    centralizedcybersecurity/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    context/tests/test_unitary_fast_hasher.py \
    context/tests/test_unitary_grpc.py \
    #context/tests/test_unitary_rest.py

#coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
#    device/tests/test_unitary_driverapi.py \
#    device/tests/test_unitary_service.py

#coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
#    service/tests/test_unitary.py

#coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
#    compute/tests/test_unitary.py

## Run integration tests and analyze coverage of code at same time
#export DB_ENGINE='redis'
#export REDIS_SERVICE_HOST='10.1.7.194'
## Find exposed port for Redis service port 6379
#export REDIS_SERVICE_PORT=$(kubectl --namespace gitlab-ci get service redis-public -o 'jsonpath={.spec.ports[?(@.port==6379)].nodePort}')
#export REDIS_DATABASE_ID='0'
#coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
#    context/tests/test_database_engine_redis.py \
#    tester_integration/test_context_device_service.py
