/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.ECI;
import com.google.zxing.common.reedsolomon.GF256;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.BlockPair;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.MatrixUtil;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        int n = 0;
        n += MaskUtil.applyMaskPenaltyRule1(byteMatrix);
        n += MaskUtil.applyMaskPenaltyRule2(byteMatrix);
        n += MaskUtil.applyMaskPenaltyRule3(byteMatrix);
        return n += MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    public static void encode(String string, ErrorCorrectionLevel errorCorrectionLevel, QRCode qRCode) throws WriterException {
        Encoder.encode(string, errorCorrectionLevel, null, qRCode);
    }

    public static void encode(String string, ErrorCorrectionLevel errorCorrectionLevel, Hashtable hashtable, QRCode qRCode) throws WriterException {
        CharacterSetECI characterSetECI;
        String string2;
        String string3 = string2 = hashtable == null ? null : (String)hashtable.get(EncodeHintType.CHARACTER_SET);
        if (string2 == null) {
            string2 = DEFAULT_BYTE_MODE_ENCODING;
        }
        Mode mode = Encoder.chooseMode(string, string2);
        BitArray bitArray = new BitArray();
        Encoder.appendBytes(string, mode, bitArray, string2);
        int n = bitArray.getSizeInBytes();
        Encoder.initQRCode(n, errorCorrectionLevel, mode, qRCode);
        BitArray bitArray2 = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(string2) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName(string2)) != null) {
            Encoder.appendECI(characterSetECI, bitArray2);
        }
        Encoder.appendModeInfo(mode, bitArray2);
        int n2 = mode.equals(Mode.BYTE) ? bitArray.getSizeInBytes() : string.length();
        Encoder.appendLengthInfo(n2, qRCode.getVersion(), mode, bitArray2);
        bitArray2.appendBitArray(bitArray);
        Encoder.terminateBits(qRCode.getNumDataBytes(), bitArray2);
        BitArray bitArray3 = new BitArray();
        Encoder.interleaveWithECBytes(bitArray2, qRCode.getNumTotalBytes(), qRCode.getNumDataBytes(), qRCode.getNumRSBlocks(), bitArray3);
        ByteMatrix byteMatrix = new ByteMatrix(qRCode.getMatrixWidth(), qRCode.getMatrixWidth());
        qRCode.setMaskPattern(Encoder.chooseMaskPattern(bitArray3, qRCode.getECLevel(), qRCode.getVersion(), byteMatrix));
        MatrixUtil.buildMatrix(bitArray3, qRCode.getECLevel(), qRCode.getVersion(), qRCode.getMaskPattern(), byteMatrix);
        qRCode.setMatrix(byteMatrix);
        if (!qRCode.isValid()) {
            throw new WriterException("Invalid QR code: " + qRCode.toString());
        }
    }

    static int getAlphanumericCode(int n) {
        if (n < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[n];
        }
        return -1;
    }

    public static Mode chooseMode(String string) {
        return Encoder.chooseMode(string, null);
    }

    public static Mode chooseMode(String string, String string2) {
        if ("Shift_JIS".equals(string2)) {
            return Encoder.isOnlyDoubleByteKanji(string) ? Mode.KANJI : Mode.BYTE;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                bl = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c) != -1) {
                bl2 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl2) {
            return Mode.ALPHANUMERIC;
        }
        if (bl) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return false;
        }
        for (int i = 0; i < n; i += 2) {
            int n2 = byArray[i] & 0xFF;
            if (n2 >= 129 && n2 <= 159 || n2 >= 224 && n2 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, int n, ByteMatrix byteMatrix) throws WriterException {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i = 0; i < 8; ++i) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, n, i, byteMatrix);
            int n4 = Encoder.calculateMaskPenalty(byteMatrix);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i;
        }
        return n3;
    }

    private static void initQRCode(int n, ErrorCorrectionLevel errorCorrectionLevel, Mode mode, QRCode qRCode) throws WriterException {
        qRCode.setECLevel(errorCorrectionLevel);
        qRCode.setMode(mode);
        for (int i = 1; i <= 40; ++i) {
            Version version = Version.getVersionForNumber(i);
            int n2 = version.getTotalCodewords();
            Version.ECBlocks eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel);
            int n3 = eCBlocks.getTotalECCodewords();
            int n4 = eCBlocks.getNumBlocks();
            int n5 = n2 - n3;
            if (n5 < n + 3) continue;
            qRCode.setVersion(i);
            qRCode.setNumTotalBytes(n2);
            qRCode.setNumDataBytes(n5);
            qRCode.setNumRSBlocks(n4);
            qRCode.setNumECBytes(n3);
            qRCode.setMatrixWidth(version.getDimensionForVersion());
            return;
        }
        throw new WriterException("Cannot find proper rs block info (input data too big?)");
    }

    static void terminateBits(int n, BitArray bitArray) throws WriterException {
        int n2;
        int n3;
        int n4 = n << 3;
        if (bitArray.getSize() > n4) {
            throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n4);
        }
        for (n3 = 0; n3 < 4 && bitArray.getSize() < n4; ++n3) {
            bitArray.appendBit(false);
        }
        n3 = bitArray.getSize() & 7;
        if (n3 > 0) {
            for (n2 = n3; n2 < 8; ++n2) {
                bitArray.appendBit(false);
            }
        }
        n2 = n - bitArray.getSizeInBytes();
        for (int i = 0; i < n2; ++i) {
            bitArray.appendBits((i & 1) == 0 ? 236 : 17, 8);
        }
        if (bitArray.getSize() != n4) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) throws WriterException {
        if (n4 >= n3) {
            throw new WriterException("Block ID too large");
        }
        int n5 = n % n3;
        int n6 = n3 - n5;
        int n7 = n / n3;
        int n8 = n2 / n3;
        int n9 = n7 - n8;
        int n10 = n7 + 1;
        int n11 = n8 + 1;
        int n12 = n10 - n11;
        if (n9 != n12) {
            throw new WriterException("EC bytes mismatch");
        }
        if (n3 != n6 + n5) {
            throw new WriterException("RS blocks mismatch");
        }
        if (n != (n8 + n9) * n6 + (n11 + n12) * n5) {
            throw new WriterException("Total bytes mismatch");
        }
        if (n4 < n6) {
            nArray[0] = n8;
            nArray2[0] = n9;
        } else {
            nArray[0] = n11;
            nArray2[0] = n12;
        }
    }

    static void interleaveWithECBytes(BitArray bitArray, int n, int n2, int n3, BitArray bitArray2) throws WriterException {
        Object[] objectArray;
        int n4;
        if (bitArray.getSizeInBytes() != n2) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Vector<BlockPair> vector = new Vector<BlockPair>(n3);
        for (n4 = 0; n4 < n3; ++n4) {
            int[] nArray = new int[1];
            objectArray = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(n, n2, n3, n4, nArray, objectArray);
            int n8 = nArray[0];
            byte[] byArray = new byte[n8];
            bitArray.toBytes(8 * n5, byArray, 0, n8);
            byte[] byArray2 = Encoder.generateECBytes(byArray, objectArray[0]);
            vector.addElement(new BlockPair(byArray, byArray2));
            n6 = Math.max(n6, n8);
            n7 = Math.max(n7, byArray2.length);
            n5 += nArray[0];
        }
        if (n2 != n5) {
            throw new WriterException("Data bytes does not match offset");
        }
        for (n4 = 0; n4 < n6; ++n4) {
            for (int i = 0; i < vector.size(); ++i) {
                objectArray = ((BlockPair)vector.elementAt(i)).getDataBytes();
                if (n4 >= objectArray.length) continue;
                bitArray2.appendBits(objectArray[n4], 8);
            }
        }
        for (n4 = 0; n4 < n7; ++n4) {
            for (int i = 0; i < vector.size(); ++i) {
                objectArray = ((BlockPair)vector.elementAt(i)).getErrorCorrectionBytes();
                if (n4 >= objectArray.length) continue;
                bitArray2.appendBits(objectArray[n4], 8);
            }
        }
        if (n != bitArray2.getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + n + " and " + bitArray2.getSizeInBytes() + " differ.");
        }
    }

    static byte[] generateECBytes(byte[] byArray, int n) {
        int n2 = byArray.length;
        int[] nArray = new int[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        new ReedSolomonEncoder(GF256.QR_CODE_FIELD).encode(nArray, n);
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = (byte)nArray[n2 + i];
        }
        return byArray2;
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int n, int n2, Mode mode, BitArray bitArray) throws WriterException {
        int n3 = mode.getCharacterCountBits(Version.getVersionForNumber(n2));
        if (n > (1 << n3) - 1) {
            throw new WriterException(n + "is bigger than" + ((1 << n3) - 1));
        }
        bitArray.appendBits(n, n3);
    }

    static void appendBytes(String string, Mode mode, BitArray bitArray, String string2) throws WriterException {
        if (mode.equals(Mode.NUMERIC)) {
            Encoder.appendNumericBytes(string, bitArray);
        } else if (mode.equals(Mode.ALPHANUMERIC)) {
            Encoder.appendAlphanumericBytes(string, bitArray);
        } else if (mode.equals(Mode.BYTE)) {
            Encoder.append8BitBytes(string, bitArray, string2);
        } else if (mode.equals(Mode.KANJI)) {
            Encoder.appendKanjiBytes(string, bitArray);
        } else {
            throw new WriterException("Invalid mode: " + mode);
        }
    }

    static void appendNumericBytes(String string, BitArray bitArray) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = string.charAt(n2) - 48;
            if (n2 + 2 < n) {
                n3 = string.charAt(n2 + 1) - 48;
                int n5 = string.charAt(n2 + 2) - 48;
                bitArray.appendBits(n4 * 100 + n3 * 10 + n5, 10);
                n2 += 3;
                continue;
            }
            if (n2 + 1 < n) {
                n3 = string.charAt(n2 + 1) - 48;
                bitArray.appendBits(n4 * 10 + n3, 7);
                n2 += 2;
                continue;
            }
            bitArray.appendBits(n4, 4);
            ++n2;
        }
    }

    static void appendAlphanumericBytes(String string, BitArray bitArray) throws WriterException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Encoder.getAlphanumericCode(string.charAt(n2));
            if (n3 == -1) {
                throw new WriterException();
            }
            if (n2 + 1 < n) {
                int n4 = Encoder.getAlphanumericCode(string.charAt(n2 + 1));
                if (n4 == -1) {
                    throw new WriterException();
                }
                bitArray.appendBits(n3 * 45 + n4, 11);
                n2 += 2;
                continue;
            }
            bitArray.appendBits(n3, 6);
            ++n2;
        }
    }

    static void append8BitBytes(String string, BitArray bitArray, String string2) throws WriterException {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException.toString());
        }
        for (int i = 0; i < byArray.length; ++i) {
            bitArray.appendBits(byArray[i], 8);
        }
    }

    static void appendKanjiBytes(String string, BitArray bitArray) throws WriterException {
        byte[] byArray;
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException.toString());
        }
        int n = byArray.length;
        for (int i = 0; i < n; i += 2) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray[i + 1] & 0xFF;
            int n4 = n2 << 8 | n3;
            int n5 = -1;
            if (n4 >= 33088 && n4 <= 40956) {
                n5 = n4 - 33088;
            } else if (n4 >= 57408 && n4 <= 60351) {
                n5 = n4 - 49472;
            }
            if (n5 == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int n6 = (n5 >> 8) * 192 + (n5 & 0xFF);
            bitArray.appendBits(n6, 13);
        }
    }

    private static void appendECI(ECI eCI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(eCI.getValue(), 8);
    }
}

