# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_forwarding_direction import TapiCommonForwardingDirection  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_diversity_policy import TapiPathComputationDiversityPolicy  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_route_objective_function import TapiPathComputationRouteObjectiveFunction  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_value_or_priority import TapiPathComputationValueOrPriority  # noqa: F401,E501
from tapi_server.models.tapi_topology_cost_characteristic import TapiTopologyCostCharacteristic  # noqa: F401,E501
from tapi_server.models.tapi_topology_latency_characteristic import TapiTopologyLatencyCharacteristic  # noqa: F401,E501
from tapi_server.models.tapi_topology_risk_characteristic import TapiTopologyRiskCharacteristic  # noqa: F401,E501
from tapi_server import util


class TapiPathComputationRoutingConstraint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, is_exclusive: bool=True, max_allowed_cost: TapiPathComputationValueOrPriority=None, diversity_policy: TapiPathComputationDiversityPolicy=None, route_objective_function: TapiPathComputationRouteObjectiveFunction=None, cost_characteristic: List[TapiTopologyCostCharacteristic]=None, max_allowed_hops: TapiPathComputationValueOrPriority=None, max_allowed_delay: TapiPathComputationValueOrPriority=None, latency_characteristic: List[TapiTopologyLatencyCharacteristic]=None, risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]=None, route_direction: TapiCommonForwardingDirection=None):  # noqa: E501
        """TapiPathComputationRoutingConstraint - a model defined in Swagger

        :param is_exclusive: The is_exclusive of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type is_exclusive: bool
        :param max_allowed_cost: The max_allowed_cost of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type max_allowed_cost: TapiPathComputationValueOrPriority
        :param diversity_policy: The diversity_policy of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type diversity_policy: TapiPathComputationDiversityPolicy
        :param route_objective_function: The route_objective_function of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type route_objective_function: TapiPathComputationRouteObjectiveFunction
        :param cost_characteristic: The cost_characteristic of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type cost_characteristic: List[TapiTopologyCostCharacteristic]
        :param max_allowed_hops: The max_allowed_hops of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type max_allowed_hops: TapiPathComputationValueOrPriority
        :param max_allowed_delay: The max_allowed_delay of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type max_allowed_delay: TapiPathComputationValueOrPriority
        :param latency_characteristic: The latency_characteristic of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type latency_characteristic: List[TapiTopologyLatencyCharacteristic]
        :param risk_diversity_characteristic: The risk_diversity_characteristic of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]
        :param route_direction: The route_direction of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :type route_direction: TapiCommonForwardingDirection
        """
        self.swagger_types = {
            'is_exclusive': bool,
            'max_allowed_cost': TapiPathComputationValueOrPriority,
            'diversity_policy': TapiPathComputationDiversityPolicy,
            'route_objective_function': TapiPathComputationRouteObjectiveFunction,
            'cost_characteristic': List[TapiTopologyCostCharacteristic],
            'max_allowed_hops': TapiPathComputationValueOrPriority,
            'max_allowed_delay': TapiPathComputationValueOrPriority,
            'latency_characteristic': List[TapiTopologyLatencyCharacteristic],
            'risk_diversity_characteristic': List[TapiTopologyRiskCharacteristic],
            'route_direction': TapiCommonForwardingDirection
        }

        self.attribute_map = {
            'is_exclusive': 'is-exclusive',
            'max_allowed_cost': 'max-allowed-cost',
            'diversity_policy': 'diversity-policy',
            'route_objective_function': 'route-objective-function',
            'cost_characteristic': 'cost-characteristic',
            'max_allowed_hops': 'max-allowed-hops',
            'max_allowed_delay': 'max-allowed-delay',
            'latency_characteristic': 'latency-characteristic',
            'risk_diversity_characteristic': 'risk-diversity-characteristic',
            'route_direction': 'route-direction'
        }
        self._is_exclusive = is_exclusive
        self._max_allowed_cost = max_allowed_cost
        self._diversity_policy = diversity_policy
        self._route_objective_function = route_objective_function
        self._cost_characteristic = cost_characteristic
        self._max_allowed_hops = max_allowed_hops
        self._max_allowed_delay = max_allowed_delay
        self._latency_characteristic = latency_characteristic
        self._risk_diversity_characteristic = risk_diversity_characteristic
        self._route_direction = route_direction

    @classmethod
    def from_dict(cls, dikt) -> 'TapiPathComputationRoutingConstraint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.path.computation.RoutingConstraint of this TapiPathComputationRoutingConstraint.  # noqa: E501
        :rtype: TapiPathComputationRoutingConstraint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def is_exclusive(self) -> bool:
        """Gets the is_exclusive of this TapiPathComputationRoutingConstraint.

        To distinguish if the resources are to be exclusive to the service  # noqa: E501

        :return: The is_exclusive of this TapiPathComputationRoutingConstraint.
        :rtype: bool
        """
        return self._is_exclusive

    @is_exclusive.setter
    def is_exclusive(self, is_exclusive: bool):
        """Sets the is_exclusive of this TapiPathComputationRoutingConstraint.

        To distinguish if the resources are to be exclusive to the service  # noqa: E501

        :param is_exclusive: The is_exclusive of this TapiPathComputationRoutingConstraint.
        :type is_exclusive: bool
        """

        self._is_exclusive = is_exclusive

    @property
    def max_allowed_cost(self) -> TapiPathComputationValueOrPriority:
        """Gets the max_allowed_cost of this TapiPathComputationRoutingConstraint.


        :return: The max_allowed_cost of this TapiPathComputationRoutingConstraint.
        :rtype: TapiPathComputationValueOrPriority
        """
        return self._max_allowed_cost

    @max_allowed_cost.setter
    def max_allowed_cost(self, max_allowed_cost: TapiPathComputationValueOrPriority):
        """Sets the max_allowed_cost of this TapiPathComputationRoutingConstraint.


        :param max_allowed_cost: The max_allowed_cost of this TapiPathComputationRoutingConstraint.
        :type max_allowed_cost: TapiPathComputationValueOrPriority
        """

        self._max_allowed_cost = max_allowed_cost

    @property
    def diversity_policy(self) -> TapiPathComputationDiversityPolicy:
        """Gets the diversity_policy of this TapiPathComputationRoutingConstraint.


        :return: The diversity_policy of this TapiPathComputationRoutingConstraint.
        :rtype: TapiPathComputationDiversityPolicy
        """
        return self._diversity_policy

    @diversity_policy.setter
    def diversity_policy(self, diversity_policy: TapiPathComputationDiversityPolicy):
        """Sets the diversity_policy of this TapiPathComputationRoutingConstraint.


        :param diversity_policy: The diversity_policy of this TapiPathComputationRoutingConstraint.
        :type diversity_policy: TapiPathComputationDiversityPolicy
        """

        self._diversity_policy = diversity_policy

    @property
    def route_objective_function(self) -> TapiPathComputationRouteObjectiveFunction:
        """Gets the route_objective_function of this TapiPathComputationRoutingConstraint.


        :return: The route_objective_function of this TapiPathComputationRoutingConstraint.
        :rtype: TapiPathComputationRouteObjectiveFunction
        """
        return self._route_objective_function

    @route_objective_function.setter
    def route_objective_function(self, route_objective_function: TapiPathComputationRouteObjectiveFunction):
        """Sets the route_objective_function of this TapiPathComputationRoutingConstraint.


        :param route_objective_function: The route_objective_function of this TapiPathComputationRoutingConstraint.
        :type route_objective_function: TapiPathComputationRouteObjectiveFunction
        """

        self._route_objective_function = route_objective_function

    @property
    def cost_characteristic(self) -> List[TapiTopologyCostCharacteristic]:
        """Gets the cost_characteristic of this TapiPathComputationRoutingConstraint.

        The list of costs where each cost relates to some aspect of the TopologicalEntity.  # noqa: E501

        :return: The cost_characteristic of this TapiPathComputationRoutingConstraint.
        :rtype: List[TapiTopologyCostCharacteristic]
        """
        return self._cost_characteristic

    @cost_characteristic.setter
    def cost_characteristic(self, cost_characteristic: List[TapiTopologyCostCharacteristic]):
        """Sets the cost_characteristic of this TapiPathComputationRoutingConstraint.

        The list of costs where each cost relates to some aspect of the TopologicalEntity.  # noqa: E501

        :param cost_characteristic: The cost_characteristic of this TapiPathComputationRoutingConstraint.
        :type cost_characteristic: List[TapiTopologyCostCharacteristic]
        """

        self._cost_characteristic = cost_characteristic

    @property
    def max_allowed_hops(self) -> TapiPathComputationValueOrPriority:
        """Gets the max_allowed_hops of this TapiPathComputationRoutingConstraint.


        :return: The max_allowed_hops of this TapiPathComputationRoutingConstraint.
        :rtype: TapiPathComputationValueOrPriority
        """
        return self._max_allowed_hops

    @max_allowed_hops.setter
    def max_allowed_hops(self, max_allowed_hops: TapiPathComputationValueOrPriority):
        """Sets the max_allowed_hops of this TapiPathComputationRoutingConstraint.


        :param max_allowed_hops: The max_allowed_hops of this TapiPathComputationRoutingConstraint.
        :type max_allowed_hops: TapiPathComputationValueOrPriority
        """

        self._max_allowed_hops = max_allowed_hops

    @property
    def max_allowed_delay(self) -> TapiPathComputationValueOrPriority:
        """Gets the max_allowed_delay of this TapiPathComputationRoutingConstraint.


        :return: The max_allowed_delay of this TapiPathComputationRoutingConstraint.
        :rtype: TapiPathComputationValueOrPriority
        """
        return self._max_allowed_delay

    @max_allowed_delay.setter
    def max_allowed_delay(self, max_allowed_delay: TapiPathComputationValueOrPriority):
        """Sets the max_allowed_delay of this TapiPathComputationRoutingConstraint.


        :param max_allowed_delay: The max_allowed_delay of this TapiPathComputationRoutingConstraint.
        :type max_allowed_delay: TapiPathComputationValueOrPriority
        """

        self._max_allowed_delay = max_allowed_delay

    @property
    def latency_characteristic(self) -> List[TapiTopologyLatencyCharacteristic]:
        """Gets the latency_characteristic of this TapiPathComputationRoutingConstraint.

        The effect on the latency of a queuing process. This only has significant effect for packet based systems and has a complex characteristic.  # noqa: E501

        :return: The latency_characteristic of this TapiPathComputationRoutingConstraint.
        :rtype: List[TapiTopologyLatencyCharacteristic]
        """
        return self._latency_characteristic

    @latency_characteristic.setter
    def latency_characteristic(self, latency_characteristic: List[TapiTopologyLatencyCharacteristic]):
        """Sets the latency_characteristic of this TapiPathComputationRoutingConstraint.

        The effect on the latency of a queuing process. This only has significant effect for packet based systems and has a complex characteristic.  # noqa: E501

        :param latency_characteristic: The latency_characteristic of this TapiPathComputationRoutingConstraint.
        :type latency_characteristic: List[TapiTopologyLatencyCharacteristic]
        """

        self._latency_characteristic = latency_characteristic

    @property
    def risk_diversity_characteristic(self) -> List[TapiTopologyRiskCharacteristic]:
        """Gets the risk_diversity_characteristic of this TapiPathComputationRoutingConstraint.

        none  # noqa: E501

        :return: The risk_diversity_characteristic of this TapiPathComputationRoutingConstraint.
        :rtype: List[TapiTopologyRiskCharacteristic]
        """
        return self._risk_diversity_characteristic

    @risk_diversity_characteristic.setter
    def risk_diversity_characteristic(self, risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]):
        """Sets the risk_diversity_characteristic of this TapiPathComputationRoutingConstraint.

        none  # noqa: E501

        :param risk_diversity_characteristic: The risk_diversity_characteristic of this TapiPathComputationRoutingConstraint.
        :type risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]
        """

        self._risk_diversity_characteristic = risk_diversity_characteristic

    @property
    def route_direction(self) -> TapiCommonForwardingDirection:
        """Gets the route_direction of this TapiPathComputationRoutingConstraint.


        :return: The route_direction of this TapiPathComputationRoutingConstraint.
        :rtype: TapiCommonForwardingDirection
        """
        return self._route_direction

    @route_direction.setter
    def route_direction(self, route_direction: TapiCommonForwardingDirection):
        """Sets the route_direction of this TapiPathComputationRoutingConstraint.


        :param route_direction: The route_direction of this TapiPathComputationRoutingConstraint.
        :type route_direction: TapiCommonForwardingDirection
        """

        self._route_direction = route_direction
