# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityResilienceRoute(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, priority: int=None, route_state: str=None):  # noqa: E501
        """TapiConnectivityResilienceRoute - a model defined in Swagger

        :param name: The name of this TapiConnectivityResilienceRoute.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiConnectivityResilienceRoute.  # noqa: E501
        :type local_id: str
        :param priority: The priority of this TapiConnectivityResilienceRoute.  # noqa: E501
        :type priority: int
        :param route_state: The route_state of this TapiConnectivityResilienceRoute.  # noqa: E501
        :type route_state: str
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'priority': int,
            'route_state': str
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'priority': 'priority',
            'route_state': 'route-state'
        }
        self._name = name
        self._local_id = local_id
        self._priority = priority
        self._route_state = route_state

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityResilienceRoute':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.ResilienceRoute of this TapiConnectivityResilienceRoute.  # noqa: E501
        :rtype: TapiConnectivityResilienceRoute
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiConnectivityResilienceRoute.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiConnectivityResilienceRoute.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiConnectivityResilienceRoute.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiConnectivityResilienceRoute.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiConnectivityResilienceRoute.

        none  # noqa: E501

        :return: The local_id of this TapiConnectivityResilienceRoute.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiConnectivityResilienceRoute.

        none  # noqa: E501

        :param local_id: The local_id of this TapiConnectivityResilienceRoute.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def priority(self) -> int:
        """Gets the priority of this TapiConnectivityResilienceRoute.

        Value of 0 (zero) means 'unspecified priority'.                  Highest priority is 1, sometimes referred as 'preferred' or 'main' or 'intended' route.                  2 has lower priority than 1, 3 has lower priority than 2, etc.  # noqa: E501

        :return: The priority of this TapiConnectivityResilienceRoute.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority: int):
        """Sets the priority of this TapiConnectivityResilienceRoute.

        Value of 0 (zero) means 'unspecified priority'.                  Highest priority is 1, sometimes referred as 'preferred' or 'main' or 'intended' route.                  2 has lower priority than 1, 3 has lower priority than 2, etc.  # noqa: E501

        :param priority: The priority of this TapiConnectivityResilienceRoute.
        :type priority: int
        """

        self._priority = priority

    @property
    def route_state(self) -> str:
        """Gets the route_state of this TapiConnectivityResilienceRoute.

        Current information on the route selection.  # noqa: E501

        :return: The route_state of this TapiConnectivityResilienceRoute.
        :rtype: str
        """
        return self._route_state

    @route_state.setter
    def route_state(self, route_state: str):
        """Sets the route_state of this TapiConnectivityResilienceRoute.

        Current information on the route selection.  # noqa: E501

        :param route_state: The route_state of this TapiConnectivityResilienceRoute.
        :type route_state: str
        """

        self._route_state = route_state
