# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_admin_state_pac import TapiCommonAdminStatePac  # noqa: F401,E501
from tapi_server.models.tapi_common_administrative_state import TapiCommonAdministrativeState  # noqa: F401,E501
from tapi_server.models.tapi_common_capacity import TapiCommonCapacity  # noqa: F401,E501
from tapi_server.models.tapi_common_forwarding_direction import TapiCommonForwardingDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_lifecycle_state import TapiCommonLifecycleState  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state import TapiCommonOperationalState  # noqa: F401,E501
from tapi_server.models.tapi_common_time_range import TapiCommonTimeRange  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_ref import TapiConnectivityConnectionRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connectivity_constraint import TapiConnectivityConnectivityConstraint  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connectivity_service_end_point import TapiConnectivityConnectivityServiceEndPoint  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connectivity_service_ref import TapiConnectivityConnectivityServiceRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_coordinate_type import TapiConnectivityCoordinateType  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_resilience_constraint import TapiConnectivityResilienceConstraint  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_reversion_mode import TapiConnectivityReversionMode  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_service_type import TapiConnectivityServiceType  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_diversity_policy import TapiPathComputationDiversityPolicy  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_route_objective_function import TapiPathComputationRouteObjectiveFunction  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_routing_constraint import TapiPathComputationRoutingConstraint  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_topology_constraint import TapiPathComputationTopologyConstraint  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_value_or_priority import TapiPathComputationValueOrPriority  # noqa: F401,E501
from tapi_server.models.tapi_topology_cost_characteristic import TapiTopologyCostCharacteristic  # noqa: F401,E501
from tapi_server.models.tapi_topology_latency_characteristic import TapiTopologyLatencyCharacteristic  # noqa: F401,E501
from tapi_server.models.tapi_topology_resilience_type import TapiTopologyResilienceType  # noqa: F401,E501
from tapi_server.models.tapi_topology_risk_characteristic import TapiTopologyRiskCharacteristic  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityConnectivityService(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, uuid: str=None, service_layer: TapiCommonLayerProtocolName=None, schedule: TapiCommonTimeRange=None, connectivity_direction: TapiCommonForwardingDirection=None, requested_capacity: TapiCommonCapacity=None, diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]=None, connection_inclusion: List[str]=None, service_level: str=None, service_type: TapiConnectivityServiceType=None, connection_exclusion: List[str]=None, coroute_inclusion: TapiConnectivityConnectivityServiceRef=None, is_lock_out: bool=False, max_switch_times: int=None, restoration_coordinate_type: TapiConnectivityCoordinateType=None, is_coordinated_switching_both_ends: bool=False, hold_off_time: int=None, is_frozen: bool=False, wait_to_revert_time: int=15, resilience_type: TapiTopologyResilienceType=None, preferred_restoration_layer: List[TapiCommonLayerProtocolName]=None, restore_priority: int=None, reversion_mode: TapiConnectivityReversionMode=None, is_exclusive: bool=True, max_allowed_cost: TapiPathComputationValueOrPriority=None, diversity_policy: TapiPathComputationDiversityPolicy=None, route_objective_function: TapiPathComputationRouteObjectiveFunction=None, cost_characteristic: List[TapiTopologyCostCharacteristic]=None, max_allowed_hops: TapiPathComputationValueOrPriority=None, max_allowed_delay: TapiPathComputationValueOrPriority=None, latency_characteristic: List[TapiTopologyLatencyCharacteristic]=None, risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]=None, route_direction: TapiCommonForwardingDirection=None, include_node: List[str]=None, exclude_link: List[str]=None, avoid_topology: List[str]=None, exclude_path: List[str]=None, include_link: List[str]=None, preferred_transport_layer: List[TapiCommonLayerProtocolName]=None, exclude_node: List[str]=None, include_topology: List[str]=None, include_path: List[str]=None, operational_state: TapiCommonOperationalState=None, lifecycle_state: TapiCommonLifecycleState=None, administrative_state: TapiCommonAdministrativeState=None, end_point: List[TapiConnectivityConnectivityServiceEndPoint]=None, connection: List[TapiConnectivityConnectionRef]=None):  # noqa: E501
        """TapiConnectivityConnectivityService - a model defined in Swagger

        :param name: The name of this TapiConnectivityConnectivityService.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiConnectivityConnectivityService.  # noqa: E501
        :type uuid: str
        :param service_layer: The service_layer of this TapiConnectivityConnectivityService.  # noqa: E501
        :type service_layer: TapiCommonLayerProtocolName
        :param schedule: The schedule of this TapiConnectivityConnectivityService.  # noqa: E501
        :type schedule: TapiCommonTimeRange
        :param connectivity_direction: The connectivity_direction of this TapiConnectivityConnectivityService.  # noqa: E501
        :type connectivity_direction: TapiCommonForwardingDirection
        :param requested_capacity: The requested_capacity of this TapiConnectivityConnectivityService.  # noqa: E501
        :type requested_capacity: TapiCommonCapacity
        :param diversity_exclusion: The diversity_exclusion of this TapiConnectivityConnectivityService.  # noqa: E501
        :type diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]
        :param connection_inclusion: The connection_inclusion of this TapiConnectivityConnectivityService.  # noqa: E501
        :type connection_inclusion: List[str]
        :param service_level: The service_level of this TapiConnectivityConnectivityService.  # noqa: E501
        :type service_level: str
        :param service_type: The service_type of this TapiConnectivityConnectivityService.  # noqa: E501
        :type service_type: TapiConnectivityServiceType
        :param connection_exclusion: The connection_exclusion of this TapiConnectivityConnectivityService.  # noqa: E501
        :type connection_exclusion: List[str]
        :param coroute_inclusion: The coroute_inclusion of this TapiConnectivityConnectivityService.  # noqa: E501
        :type coroute_inclusion: TapiConnectivityConnectivityServiceRef
        :param is_lock_out: The is_lock_out of this TapiConnectivityConnectivityService.  # noqa: E501
        :type is_lock_out: bool
        :param max_switch_times: The max_switch_times of this TapiConnectivityConnectivityService.  # noqa: E501
        :type max_switch_times: int
        :param restoration_coordinate_type: The restoration_coordinate_type of this TapiConnectivityConnectivityService.  # noqa: E501
        :type restoration_coordinate_type: TapiConnectivityCoordinateType
        :param is_coordinated_switching_both_ends: The is_coordinated_switching_both_ends of this TapiConnectivityConnectivityService.  # noqa: E501
        :type is_coordinated_switching_both_ends: bool
        :param hold_off_time: The hold_off_time of this TapiConnectivityConnectivityService.  # noqa: E501
        :type hold_off_time: int
        :param is_frozen: The is_frozen of this TapiConnectivityConnectivityService.  # noqa: E501
        :type is_frozen: bool
        :param wait_to_revert_time: The wait_to_revert_time of this TapiConnectivityConnectivityService.  # noqa: E501
        :type wait_to_revert_time: int
        :param resilience_type: The resilience_type of this TapiConnectivityConnectivityService.  # noqa: E501
        :type resilience_type: TapiTopologyResilienceType
        :param preferred_restoration_layer: The preferred_restoration_layer of this TapiConnectivityConnectivityService.  # noqa: E501
        :type preferred_restoration_layer: List[TapiCommonLayerProtocolName]
        :param restore_priority: The restore_priority of this TapiConnectivityConnectivityService.  # noqa: E501
        :type restore_priority: int
        :param reversion_mode: The reversion_mode of this TapiConnectivityConnectivityService.  # noqa: E501
        :type reversion_mode: TapiConnectivityReversionMode
        :param is_exclusive: The is_exclusive of this TapiConnectivityConnectivityService.  # noqa: E501
        :type is_exclusive: bool
        :param max_allowed_cost: The max_allowed_cost of this TapiConnectivityConnectivityService.  # noqa: E501
        :type max_allowed_cost: TapiPathComputationValueOrPriority
        :param diversity_policy: The diversity_policy of this TapiConnectivityConnectivityService.  # noqa: E501
        :type diversity_policy: TapiPathComputationDiversityPolicy
        :param route_objective_function: The route_objective_function of this TapiConnectivityConnectivityService.  # noqa: E501
        :type route_objective_function: TapiPathComputationRouteObjectiveFunction
        :param cost_characteristic: The cost_characteristic of this TapiConnectivityConnectivityService.  # noqa: E501
        :type cost_characteristic: List[TapiTopologyCostCharacteristic]
        :param max_allowed_hops: The max_allowed_hops of this TapiConnectivityConnectivityService.  # noqa: E501
        :type max_allowed_hops: TapiPathComputationValueOrPriority
        :param max_allowed_delay: The max_allowed_delay of this TapiConnectivityConnectivityService.  # noqa: E501
        :type max_allowed_delay: TapiPathComputationValueOrPriority
        :param latency_characteristic: The latency_characteristic of this TapiConnectivityConnectivityService.  # noqa: E501
        :type latency_characteristic: List[TapiTopologyLatencyCharacteristic]
        :param risk_diversity_characteristic: The risk_diversity_characteristic of this TapiConnectivityConnectivityService.  # noqa: E501
        :type risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]
        :param route_direction: The route_direction of this TapiConnectivityConnectivityService.  # noqa: E501
        :type route_direction: TapiCommonForwardingDirection
        :param include_node: The include_node of this TapiConnectivityConnectivityService.  # noqa: E501
        :type include_node: List[str]
        :param exclude_link: The exclude_link of this TapiConnectivityConnectivityService.  # noqa: E501
        :type exclude_link: List[str]
        :param avoid_topology: The avoid_topology of this TapiConnectivityConnectivityService.  # noqa: E501
        :type avoid_topology: List[str]
        :param exclude_path: The exclude_path of this TapiConnectivityConnectivityService.  # noqa: E501
        :type exclude_path: List[str]
        :param include_link: The include_link of this TapiConnectivityConnectivityService.  # noqa: E501
        :type include_link: List[str]
        :param preferred_transport_layer: The preferred_transport_layer of this TapiConnectivityConnectivityService.  # noqa: E501
        :type preferred_transport_layer: List[TapiCommonLayerProtocolName]
        :param exclude_node: The exclude_node of this TapiConnectivityConnectivityService.  # noqa: E501
        :type exclude_node: List[str]
        :param include_topology: The include_topology of this TapiConnectivityConnectivityService.  # noqa: E501
        :type include_topology: List[str]
        :param include_path: The include_path of this TapiConnectivityConnectivityService.  # noqa: E501
        :type include_path: List[str]
        :param operational_state: The operational_state of this TapiConnectivityConnectivityService.  # noqa: E501
        :type operational_state: TapiCommonOperationalState
        :param lifecycle_state: The lifecycle_state of this TapiConnectivityConnectivityService.  # noqa: E501
        :type lifecycle_state: TapiCommonLifecycleState
        :param administrative_state: The administrative_state of this TapiConnectivityConnectivityService.  # noqa: E501
        :type administrative_state: TapiCommonAdministrativeState
        :param end_point: The end_point of this TapiConnectivityConnectivityService.  # noqa: E501
        :type end_point: List[TapiConnectivityConnectivityServiceEndPoint]
        :param connection: The connection of this TapiConnectivityConnectivityService.  # noqa: E501
        :type connection: List[TapiConnectivityConnectionRef]
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'service_layer': TapiCommonLayerProtocolName,
            'schedule': TapiCommonTimeRange,
            'connectivity_direction': TapiCommonForwardingDirection,
            'requested_capacity': TapiCommonCapacity,
            'diversity_exclusion': List[TapiConnectivityConnectivityServiceRef],
            'connection_inclusion': List[str],
            'service_level': str,
            'service_type': TapiConnectivityServiceType,
            'connection_exclusion': List[str],
            'coroute_inclusion': TapiConnectivityConnectivityServiceRef,
            'is_lock_out': bool,
            'max_switch_times': int,
            'restoration_coordinate_type': TapiConnectivityCoordinateType,
            'is_coordinated_switching_both_ends': bool,
            'hold_off_time': int,
            'is_frozen': bool,
            'wait_to_revert_time': int,
            'resilience_type': TapiTopologyResilienceType,
            'preferred_restoration_layer': List[TapiCommonLayerProtocolName],
            'restore_priority': int,
            'reversion_mode': TapiConnectivityReversionMode,
            'is_exclusive': bool,
            'max_allowed_cost': TapiPathComputationValueOrPriority,
            'diversity_policy': TapiPathComputationDiversityPolicy,
            'route_objective_function': TapiPathComputationRouteObjectiveFunction,
            'cost_characteristic': List[TapiTopologyCostCharacteristic],
            'max_allowed_hops': TapiPathComputationValueOrPriority,
            'max_allowed_delay': TapiPathComputationValueOrPriority,
            'latency_characteristic': List[TapiTopologyLatencyCharacteristic],
            'risk_diversity_characteristic': List[TapiTopologyRiskCharacteristic],
            'route_direction': TapiCommonForwardingDirection,
            'include_node': List[str],
            'exclude_link': List[str],
            'avoid_topology': List[str],
            'exclude_path': List[str],
            'include_link': List[str],
            'preferred_transport_layer': List[TapiCommonLayerProtocolName],
            'exclude_node': List[str],
            'include_topology': List[str],
            'include_path': List[str],
            'operational_state': TapiCommonOperationalState,
            'lifecycle_state': TapiCommonLifecycleState,
            'administrative_state': TapiCommonAdministrativeState,
            'end_point': List[TapiConnectivityConnectivityServiceEndPoint],
            'connection': List[TapiConnectivityConnectionRef]
        }

        self.attribute_map = {
            'name': 'name',
            'uuid': 'uuid',
            'service_layer': 'service-layer',
            'schedule': 'schedule',
            'connectivity_direction': 'connectivity-direction',
            'requested_capacity': 'requested-capacity',
            'diversity_exclusion': 'diversity-exclusion',
            'connection_inclusion': 'connection-inclusion',
            'service_level': 'service-level',
            'service_type': 'service-type',
            'connection_exclusion': 'connection-exclusion',
            'coroute_inclusion': 'coroute-inclusion',
            'is_lock_out': 'is-lock-out',
            'max_switch_times': 'max-switch-times',
            'restoration_coordinate_type': 'restoration-coordinate-type',
            'is_coordinated_switching_both_ends': 'is-coordinated-switching-both-ends',
            'hold_off_time': 'hold-off-time',
            'is_frozen': 'is-frozen',
            'wait_to_revert_time': 'wait-to-revert-time',
            'resilience_type': 'resilience-type',
            'preferred_restoration_layer': 'preferred-restoration-layer',
            'restore_priority': 'restore-priority',
            'reversion_mode': 'reversion-mode',
            'is_exclusive': 'is-exclusive',
            'max_allowed_cost': 'max-allowed-cost',
            'diversity_policy': 'diversity-policy',
            'route_objective_function': 'route-objective-function',
            'cost_characteristic': 'cost-characteristic',
            'max_allowed_hops': 'max-allowed-hops',
            'max_allowed_delay': 'max-allowed-delay',
            'latency_characteristic': 'latency-characteristic',
            'risk_diversity_characteristic': 'risk-diversity-characteristic',
            'route_direction': 'route-direction',
            'include_node': 'include-node',
            'exclude_link': 'exclude-link',
            'avoid_topology': 'avoid-topology',
            'exclude_path': 'exclude-path',
            'include_link': 'include-link',
            'preferred_transport_layer': 'preferred-transport-layer',
            'exclude_node': 'exclude-node',
            'include_topology': 'include-topology',
            'include_path': 'include-path',
            'operational_state': 'operational-state',
            'lifecycle_state': 'lifecycle-state',
            'administrative_state': 'administrative-state',
            'end_point': 'end-point',
            'connection': 'connection'
        }
        self._name = name
        self._uuid = uuid
        self._service_layer = service_layer
        self._schedule = schedule
        self._connectivity_direction = connectivity_direction
        self._requested_capacity = requested_capacity
        self._diversity_exclusion = diversity_exclusion
        self._connection_inclusion = connection_inclusion
        self._service_level = service_level
        self._service_type = service_type
        self._connection_exclusion = connection_exclusion
        self._coroute_inclusion = coroute_inclusion
        self._is_lock_out = is_lock_out
        self._max_switch_times = max_switch_times
        self._restoration_coordinate_type = restoration_coordinate_type
        self._is_coordinated_switching_both_ends = is_coordinated_switching_both_ends
        self._hold_off_time = hold_off_time
        self._is_frozen = is_frozen
        self._wait_to_revert_time = wait_to_revert_time
        self._resilience_type = resilience_type
        self._preferred_restoration_layer = preferred_restoration_layer
        self._restore_priority = restore_priority
        self._reversion_mode = reversion_mode
        self._is_exclusive = is_exclusive
        self._max_allowed_cost = max_allowed_cost
        self._diversity_policy = diversity_policy
        self._route_objective_function = route_objective_function
        self._cost_characteristic = cost_characteristic
        self._max_allowed_hops = max_allowed_hops
        self._max_allowed_delay = max_allowed_delay
        self._latency_characteristic = latency_characteristic
        self._risk_diversity_characteristic = risk_diversity_characteristic
        self._route_direction = route_direction
        self._include_node = include_node
        self._exclude_link = exclude_link
        self._avoid_topology = avoid_topology
        self._exclude_path = exclude_path
        self._include_link = include_link
        self._preferred_transport_layer = preferred_transport_layer
        self._exclude_node = exclude_node
        self._include_topology = include_topology
        self._include_path = include_path
        self._operational_state = operational_state
        self._lifecycle_state = lifecycle_state
        self._administrative_state = administrative_state
        self._end_point = end_point
        self._connection = connection

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityConnectivityService':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.ConnectivityService of this TapiConnectivityConnectivityService.  # noqa: E501
        :rtype: TapiConnectivityConnectivityService
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiConnectivityConnectivityService.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiConnectivityConnectivityService.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiConnectivityConnectivityService.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiConnectivityConnectivityService.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiConnectivityConnectivityService.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiConnectivityConnectivityService.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiConnectivityConnectivityService.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiConnectivityConnectivityService.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def service_layer(self) -> TapiCommonLayerProtocolName:
        """Gets the service_layer of this TapiConnectivityConnectivityService.


        :return: The service_layer of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._service_layer

    @service_layer.setter
    def service_layer(self, service_layer: TapiCommonLayerProtocolName):
        """Sets the service_layer of this TapiConnectivityConnectivityService.


        :param service_layer: The service_layer of this TapiConnectivityConnectivityService.
        :type service_layer: TapiCommonLayerProtocolName
        """

        self._service_layer = service_layer

    @property
    def schedule(self) -> TapiCommonTimeRange:
        """Gets the schedule of this TapiConnectivityConnectivityService.


        :return: The schedule of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonTimeRange
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule: TapiCommonTimeRange):
        """Sets the schedule of this TapiConnectivityConnectivityService.


        :param schedule: The schedule of this TapiConnectivityConnectivityService.
        :type schedule: TapiCommonTimeRange
        """

        self._schedule = schedule

    @property
    def connectivity_direction(self) -> TapiCommonForwardingDirection:
        """Gets the connectivity_direction of this TapiConnectivityConnectivityService.


        :return: The connectivity_direction of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonForwardingDirection
        """
        return self._connectivity_direction

    @connectivity_direction.setter
    def connectivity_direction(self, connectivity_direction: TapiCommonForwardingDirection):
        """Sets the connectivity_direction of this TapiConnectivityConnectivityService.


        :param connectivity_direction: The connectivity_direction of this TapiConnectivityConnectivityService.
        :type connectivity_direction: TapiCommonForwardingDirection
        """

        self._connectivity_direction = connectivity_direction

    @property
    def requested_capacity(self) -> TapiCommonCapacity:
        """Gets the requested_capacity of this TapiConnectivityConnectivityService.


        :return: The requested_capacity of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonCapacity
        """
        return self._requested_capacity

    @requested_capacity.setter
    def requested_capacity(self, requested_capacity: TapiCommonCapacity):
        """Sets the requested_capacity of this TapiConnectivityConnectivityService.


        :param requested_capacity: The requested_capacity of this TapiConnectivityConnectivityService.
        :type requested_capacity: TapiCommonCapacity
        """

        self._requested_capacity = requested_capacity

    @property
    def diversity_exclusion(self) -> List[TapiConnectivityConnectivityServiceRef]:
        """Gets the diversity_exclusion of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The diversity_exclusion of this TapiConnectivityConnectivityService.
        :rtype: List[TapiConnectivityConnectivityServiceRef]
        """
        return self._diversity_exclusion

    @diversity_exclusion.setter
    def diversity_exclusion(self, diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]):
        """Sets the diversity_exclusion of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param diversity_exclusion: The diversity_exclusion of this TapiConnectivityConnectivityService.
        :type diversity_exclusion: List[TapiConnectivityConnectivityServiceRef]
        """

        self._diversity_exclusion = diversity_exclusion

    @property
    def connection_inclusion(self) -> List[str]:
        """Gets the connection_inclusion of this TapiConnectivityConnectivityService.

        A ConnectivityService may use one or more existing Connections.                  A common traditional strategy is to set up “stranded” connectivity in the core of the network as “express channels” (this is essentially a serial compound link, but can be treated as simple connections)                  A connection inclusion capability allows for adoption of a discovered Connections.                  A ConnectivityService is requested with a connection inclusion constraint that identifies a connection (or chain of connections) that is bounded by CEPs that each belong to a NEP that references a SIP that is referenced by a CSEP of the ConnectivityService such that all CSEPs are satisfied by CEPs of the existing Connection. will allow discovered Connections with no stated intent to be associated with an intent via the ConnectivityService.  # noqa: E501

        :return: The connection_inclusion of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._connection_inclusion

    @connection_inclusion.setter
    def connection_inclusion(self, connection_inclusion: List[str]):
        """Sets the connection_inclusion of this TapiConnectivityConnectivityService.

        A ConnectivityService may use one or more existing Connections.                  A common traditional strategy is to set up “stranded” connectivity in the core of the network as “express channels” (this is essentially a serial compound link, but can be treated as simple connections)                  A connection inclusion capability allows for adoption of a discovered Connections.                  A ConnectivityService is requested with a connection inclusion constraint that identifies a connection (or chain of connections) that is bounded by CEPs that each belong to a NEP that references a SIP that is referenced by a CSEP of the ConnectivityService such that all CSEPs are satisfied by CEPs of the existing Connection. will allow discovered Connections with no stated intent to be associated with an intent via the ConnectivityService.  # noqa: E501

        :param connection_inclusion: The connection_inclusion of this TapiConnectivityConnectivityService.
        :type connection_inclusion: List[str]
        """

        self._connection_inclusion = connection_inclusion

    @property
    def service_level(self) -> str:
        """Gets the service_level of this TapiConnectivityConnectivityService.

        An abstract value the meaning of which is mutually agreed – typically represents metrics such as - Class of service, priority, resiliency, availability  # noqa: E501

        :return: The service_level of this TapiConnectivityConnectivityService.
        :rtype: str
        """
        return self._service_level

    @service_level.setter
    def service_level(self, service_level: str):
        """Sets the service_level of this TapiConnectivityConnectivityService.

        An abstract value the meaning of which is mutually agreed – typically represents metrics such as - Class of service, priority, resiliency, availability  # noqa: E501

        :param service_level: The service_level of this TapiConnectivityConnectivityService.
        :type service_level: str
        """

        self._service_level = service_level

    @property
    def service_type(self) -> TapiConnectivityServiceType:
        """Gets the service_type of this TapiConnectivityConnectivityService.


        :return: The service_type of this TapiConnectivityConnectivityService.
        :rtype: TapiConnectivityServiceType
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type: TapiConnectivityServiceType):
        """Sets the service_type of this TapiConnectivityConnectivityService.


        :param service_type: The service_type of this TapiConnectivityConnectivityService.
        :type service_type: TapiConnectivityServiceType
        """

        self._service_type = service_type

    @property
    def connection_exclusion(self) -> List[str]:
        """Gets the connection_exclusion of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The connection_exclusion of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._connection_exclusion

    @connection_exclusion.setter
    def connection_exclusion(self, connection_exclusion: List[str]):
        """Sets the connection_exclusion of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param connection_exclusion: The connection_exclusion of this TapiConnectivityConnectivityService.
        :type connection_exclusion: List[str]
        """

        self._connection_exclusion = connection_exclusion

    @property
    def coroute_inclusion(self) -> TapiConnectivityConnectivityServiceRef:
        """Gets the coroute_inclusion of this TapiConnectivityConnectivityService.


        :return: The coroute_inclusion of this TapiConnectivityConnectivityService.
        :rtype: TapiConnectivityConnectivityServiceRef
        """
        return self._coroute_inclusion

    @coroute_inclusion.setter
    def coroute_inclusion(self, coroute_inclusion: TapiConnectivityConnectivityServiceRef):
        """Sets the coroute_inclusion of this TapiConnectivityConnectivityService.


        :param coroute_inclusion: The coroute_inclusion of this TapiConnectivityConnectivityService.
        :type coroute_inclusion: TapiConnectivityConnectivityServiceRef
        """

        self._coroute_inclusion = coroute_inclusion

    @property
    def is_lock_out(self) -> bool:
        """Gets the is_lock_out of this TapiConnectivityConnectivityService.

        The resource is configured to temporarily not be available for use in the protection scheme(s) it is part of.                  This overrides all other protection control states including forced.                  If the item is locked out then it cannot be used under any circumstances.                  Note: Only relevant when part of a protection scheme.  # noqa: E501

        :return: The is_lock_out of this TapiConnectivityConnectivityService.
        :rtype: bool
        """
        return self._is_lock_out

    @is_lock_out.setter
    def is_lock_out(self, is_lock_out: bool):
        """Sets the is_lock_out of this TapiConnectivityConnectivityService.

        The resource is configured to temporarily not be available for use in the protection scheme(s) it is part of.                  This overrides all other protection control states including forced.                  If the item is locked out then it cannot be used under any circumstances.                  Note: Only relevant when part of a protection scheme.  # noqa: E501

        :param is_lock_out: The is_lock_out of this TapiConnectivityConnectivityService.
        :type is_lock_out: bool
        """

        self._is_lock_out = is_lock_out

    @property
    def max_switch_times(self) -> int:
        """Gets the max_switch_times of this TapiConnectivityConnectivityService.

        Used to limit the maximum swtich times. When work fault disappears , and traffic return to the original work path, switch counter reset.  # noqa: E501

        :return: The max_switch_times of this TapiConnectivityConnectivityService.
        :rtype: int
        """
        return self._max_switch_times

    @max_switch_times.setter
    def max_switch_times(self, max_switch_times: int):
        """Sets the max_switch_times of this TapiConnectivityConnectivityService.

        Used to limit the maximum swtich times. When work fault disappears , and traffic return to the original work path, switch counter reset.  # noqa: E501

        :param max_switch_times: The max_switch_times of this TapiConnectivityConnectivityService.
        :type max_switch_times: int
        """

        self._max_switch_times = max_switch_times

    @property
    def restoration_coordinate_type(self) -> TapiConnectivityCoordinateType:
        """Gets the restoration_coordinate_type of this TapiConnectivityConnectivityService.


        :return: The restoration_coordinate_type of this TapiConnectivityConnectivityService.
        :rtype: TapiConnectivityCoordinateType
        """
        return self._restoration_coordinate_type

    @restoration_coordinate_type.setter
    def restoration_coordinate_type(self, restoration_coordinate_type: TapiConnectivityCoordinateType):
        """Sets the restoration_coordinate_type of this TapiConnectivityConnectivityService.


        :param restoration_coordinate_type: The restoration_coordinate_type of this TapiConnectivityConnectivityService.
        :type restoration_coordinate_type: TapiConnectivityCoordinateType
        """

        self._restoration_coordinate_type = restoration_coordinate_type

    @property
    def is_coordinated_switching_both_ends(self) -> bool:
        """Gets the is_coordinated_switching_both_ends of this TapiConnectivityConnectivityService.

        Is operating such that switching at both ends of each flow acorss the FC is coordinated at both ingress and egress ends.  # noqa: E501

        :return: The is_coordinated_switching_both_ends of this TapiConnectivityConnectivityService.
        :rtype: bool
        """
        return self._is_coordinated_switching_both_ends

    @is_coordinated_switching_both_ends.setter
    def is_coordinated_switching_both_ends(self, is_coordinated_switching_both_ends: bool):
        """Sets the is_coordinated_switching_both_ends of this TapiConnectivityConnectivityService.

        Is operating such that switching at both ends of each flow acorss the FC is coordinated at both ingress and egress ends.  # noqa: E501

        :param is_coordinated_switching_both_ends: The is_coordinated_switching_both_ends of this TapiConnectivityConnectivityService.
        :type is_coordinated_switching_both_ends: bool
        """

        self._is_coordinated_switching_both_ends = is_coordinated_switching_both_ends

    @property
    def hold_off_time(self) -> int:
        """Gets the hold_off_time of this TapiConnectivityConnectivityService.

        This attribute indicates the time, in milliseconds, between declaration of signal degrade or signal fail, and the initialization of the protection switching algorithm.  # noqa: E501

        :return: The hold_off_time of this TapiConnectivityConnectivityService.
        :rtype: int
        """
        return self._hold_off_time

    @hold_off_time.setter
    def hold_off_time(self, hold_off_time: int):
        """Sets the hold_off_time of this TapiConnectivityConnectivityService.

        This attribute indicates the time, in milliseconds, between declaration of signal degrade or signal fail, and the initialization of the protection switching algorithm.  # noqa: E501

        :param hold_off_time: The hold_off_time of this TapiConnectivityConnectivityService.
        :type hold_off_time: int
        """

        self._hold_off_time = hold_off_time

    @property
    def is_frozen(self) -> bool:
        """Gets the is_frozen of this TapiConnectivityConnectivityService.

        Temporarily prevents any switch action to be taken and, as such, freezes the current state.                   Until the freeze is cleared, additional near-end external commands are rejected and fault condition changes and received APS messages are ignored.                  All administrative controls of any aspect of protection are rejected.  # noqa: E501

        :return: The is_frozen of this TapiConnectivityConnectivityService.
        :rtype: bool
        """
        return self._is_frozen

    @is_frozen.setter
    def is_frozen(self, is_frozen: bool):
        """Sets the is_frozen of this TapiConnectivityConnectivityService.

        Temporarily prevents any switch action to be taken and, as such, freezes the current state.                   Until the freeze is cleared, additional near-end external commands are rejected and fault condition changes and received APS messages are ignored.                  All administrative controls of any aspect of protection are rejected.  # noqa: E501

        :param is_frozen: The is_frozen of this TapiConnectivityConnectivityService.
        :type is_frozen: bool
        """

        self._is_frozen = is_frozen

    @property
    def wait_to_revert_time(self) -> int:
        """Gets the wait_to_revert_time of this TapiConnectivityConnectivityService.

        If the protection system is revertive, this attribute specifies the time, in minutes, to wait after a fault clears on a higher priority (preferred) resource before reverting to the preferred resource.  # noqa: E501

        :return: The wait_to_revert_time of this TapiConnectivityConnectivityService.
        :rtype: int
        """
        return self._wait_to_revert_time

    @wait_to_revert_time.setter
    def wait_to_revert_time(self, wait_to_revert_time: int):
        """Sets the wait_to_revert_time of this TapiConnectivityConnectivityService.

        If the protection system is revertive, this attribute specifies the time, in minutes, to wait after a fault clears on a higher priority (preferred) resource before reverting to the preferred resource.  # noqa: E501

        :param wait_to_revert_time: The wait_to_revert_time of this TapiConnectivityConnectivityService.
        :type wait_to_revert_time: int
        """

        self._wait_to_revert_time = wait_to_revert_time

    @property
    def resilience_type(self) -> TapiTopologyResilienceType:
        """Gets the resilience_type of this TapiConnectivityConnectivityService.


        :return: The resilience_type of this TapiConnectivityConnectivityService.
        :rtype: TapiTopologyResilienceType
        """
        return self._resilience_type

    @resilience_type.setter
    def resilience_type(self, resilience_type: TapiTopologyResilienceType):
        """Sets the resilience_type of this TapiConnectivityConnectivityService.


        :param resilience_type: The resilience_type of this TapiConnectivityConnectivityService.
        :type resilience_type: TapiTopologyResilienceType
        """

        self._resilience_type = resilience_type

    @property
    def preferred_restoration_layer(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the preferred_restoration_layer of this TapiConnectivityConnectivityService.

        Indicate which layer this resilience parameters package configured for.  # noqa: E501

        :return: The preferred_restoration_layer of this TapiConnectivityConnectivityService.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._preferred_restoration_layer

    @preferred_restoration_layer.setter
    def preferred_restoration_layer(self, preferred_restoration_layer: List[TapiCommonLayerProtocolName]):
        """Sets the preferred_restoration_layer of this TapiConnectivityConnectivityService.

        Indicate which layer this resilience parameters package configured for.  # noqa: E501

        :param preferred_restoration_layer: The preferred_restoration_layer of this TapiConnectivityConnectivityService.
        :type preferred_restoration_layer: List[TapiCommonLayerProtocolName]
        """

        self._preferred_restoration_layer = preferred_restoration_layer

    @property
    def restore_priority(self) -> int:
        """Gets the restore_priority of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The restore_priority of this TapiConnectivityConnectivityService.
        :rtype: int
        """
        return self._restore_priority

    @restore_priority.setter
    def restore_priority(self, restore_priority: int):
        """Sets the restore_priority of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param restore_priority: The restore_priority of this TapiConnectivityConnectivityService.
        :type restore_priority: int
        """

        self._restore_priority = restore_priority

    @property
    def reversion_mode(self) -> TapiConnectivityReversionMode:
        """Gets the reversion_mode of this TapiConnectivityConnectivityService.


        :return: The reversion_mode of this TapiConnectivityConnectivityService.
        :rtype: TapiConnectivityReversionMode
        """
        return self._reversion_mode

    @reversion_mode.setter
    def reversion_mode(self, reversion_mode: TapiConnectivityReversionMode):
        """Sets the reversion_mode of this TapiConnectivityConnectivityService.


        :param reversion_mode: The reversion_mode of this TapiConnectivityConnectivityService.
        :type reversion_mode: TapiConnectivityReversionMode
        """

        self._reversion_mode = reversion_mode

    @property
    def is_exclusive(self) -> bool:
        """Gets the is_exclusive of this TapiConnectivityConnectivityService.

        To distinguish if the resources are to be exclusive to the service  # noqa: E501

        :return: The is_exclusive of this TapiConnectivityConnectivityService.
        :rtype: bool
        """
        return self._is_exclusive

    @is_exclusive.setter
    def is_exclusive(self, is_exclusive: bool):
        """Sets the is_exclusive of this TapiConnectivityConnectivityService.

        To distinguish if the resources are to be exclusive to the service  # noqa: E501

        :param is_exclusive: The is_exclusive of this TapiConnectivityConnectivityService.
        :type is_exclusive: bool
        """

        self._is_exclusive = is_exclusive

    @property
    def max_allowed_cost(self) -> TapiPathComputationValueOrPriority:
        """Gets the max_allowed_cost of this TapiConnectivityConnectivityService.


        :return: The max_allowed_cost of this TapiConnectivityConnectivityService.
        :rtype: TapiPathComputationValueOrPriority
        """
        return self._max_allowed_cost

    @max_allowed_cost.setter
    def max_allowed_cost(self, max_allowed_cost: TapiPathComputationValueOrPriority):
        """Sets the max_allowed_cost of this TapiConnectivityConnectivityService.


        :param max_allowed_cost: The max_allowed_cost of this TapiConnectivityConnectivityService.
        :type max_allowed_cost: TapiPathComputationValueOrPriority
        """

        self._max_allowed_cost = max_allowed_cost

    @property
    def diversity_policy(self) -> TapiPathComputationDiversityPolicy:
        """Gets the diversity_policy of this TapiConnectivityConnectivityService.


        :return: The diversity_policy of this TapiConnectivityConnectivityService.
        :rtype: TapiPathComputationDiversityPolicy
        """
        return self._diversity_policy

    @diversity_policy.setter
    def diversity_policy(self, diversity_policy: TapiPathComputationDiversityPolicy):
        """Sets the diversity_policy of this TapiConnectivityConnectivityService.


        :param diversity_policy: The diversity_policy of this TapiConnectivityConnectivityService.
        :type diversity_policy: TapiPathComputationDiversityPolicy
        """

        self._diversity_policy = diversity_policy

    @property
    def route_objective_function(self) -> TapiPathComputationRouteObjectiveFunction:
        """Gets the route_objective_function of this TapiConnectivityConnectivityService.


        :return: The route_objective_function of this TapiConnectivityConnectivityService.
        :rtype: TapiPathComputationRouteObjectiveFunction
        """
        return self._route_objective_function

    @route_objective_function.setter
    def route_objective_function(self, route_objective_function: TapiPathComputationRouteObjectiveFunction):
        """Sets the route_objective_function of this TapiConnectivityConnectivityService.


        :param route_objective_function: The route_objective_function of this TapiConnectivityConnectivityService.
        :type route_objective_function: TapiPathComputationRouteObjectiveFunction
        """

        self._route_objective_function = route_objective_function

    @property
    def cost_characteristic(self) -> List[TapiTopologyCostCharacteristic]:
        """Gets the cost_characteristic of this TapiConnectivityConnectivityService.

        The list of costs where each cost relates to some aspect of the TopologicalEntity.  # noqa: E501

        :return: The cost_characteristic of this TapiConnectivityConnectivityService.
        :rtype: List[TapiTopologyCostCharacteristic]
        """
        return self._cost_characteristic

    @cost_characteristic.setter
    def cost_characteristic(self, cost_characteristic: List[TapiTopologyCostCharacteristic]):
        """Sets the cost_characteristic of this TapiConnectivityConnectivityService.

        The list of costs where each cost relates to some aspect of the TopologicalEntity.  # noqa: E501

        :param cost_characteristic: The cost_characteristic of this TapiConnectivityConnectivityService.
        :type cost_characteristic: List[TapiTopologyCostCharacteristic]
        """

        self._cost_characteristic = cost_characteristic

    @property
    def max_allowed_hops(self) -> TapiPathComputationValueOrPriority:
        """Gets the max_allowed_hops of this TapiConnectivityConnectivityService.


        :return: The max_allowed_hops of this TapiConnectivityConnectivityService.
        :rtype: TapiPathComputationValueOrPriority
        """
        return self._max_allowed_hops

    @max_allowed_hops.setter
    def max_allowed_hops(self, max_allowed_hops: TapiPathComputationValueOrPriority):
        """Sets the max_allowed_hops of this TapiConnectivityConnectivityService.


        :param max_allowed_hops: The max_allowed_hops of this TapiConnectivityConnectivityService.
        :type max_allowed_hops: TapiPathComputationValueOrPriority
        """

        self._max_allowed_hops = max_allowed_hops

    @property
    def max_allowed_delay(self) -> TapiPathComputationValueOrPriority:
        """Gets the max_allowed_delay of this TapiConnectivityConnectivityService.


        :return: The max_allowed_delay of this TapiConnectivityConnectivityService.
        :rtype: TapiPathComputationValueOrPriority
        """
        return self._max_allowed_delay

    @max_allowed_delay.setter
    def max_allowed_delay(self, max_allowed_delay: TapiPathComputationValueOrPriority):
        """Sets the max_allowed_delay of this TapiConnectivityConnectivityService.


        :param max_allowed_delay: The max_allowed_delay of this TapiConnectivityConnectivityService.
        :type max_allowed_delay: TapiPathComputationValueOrPriority
        """

        self._max_allowed_delay = max_allowed_delay

    @property
    def latency_characteristic(self) -> List[TapiTopologyLatencyCharacteristic]:
        """Gets the latency_characteristic of this TapiConnectivityConnectivityService.

        The effect on the latency of a queuing process. This only has significant effect for packet based systems and has a complex characteristic.  # noqa: E501

        :return: The latency_characteristic of this TapiConnectivityConnectivityService.
        :rtype: List[TapiTopologyLatencyCharacteristic]
        """
        return self._latency_characteristic

    @latency_characteristic.setter
    def latency_characteristic(self, latency_characteristic: List[TapiTopologyLatencyCharacteristic]):
        """Sets the latency_characteristic of this TapiConnectivityConnectivityService.

        The effect on the latency of a queuing process. This only has significant effect for packet based systems and has a complex characteristic.  # noqa: E501

        :param latency_characteristic: The latency_characteristic of this TapiConnectivityConnectivityService.
        :type latency_characteristic: List[TapiTopologyLatencyCharacteristic]
        """

        self._latency_characteristic = latency_characteristic

    @property
    def risk_diversity_characteristic(self) -> List[TapiTopologyRiskCharacteristic]:
        """Gets the risk_diversity_characteristic of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The risk_diversity_characteristic of this TapiConnectivityConnectivityService.
        :rtype: List[TapiTopologyRiskCharacteristic]
        """
        return self._risk_diversity_characteristic

    @risk_diversity_characteristic.setter
    def risk_diversity_characteristic(self, risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]):
        """Sets the risk_diversity_characteristic of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param risk_diversity_characteristic: The risk_diversity_characteristic of this TapiConnectivityConnectivityService.
        :type risk_diversity_characteristic: List[TapiTopologyRiskCharacteristic]
        """

        self._risk_diversity_characteristic = risk_diversity_characteristic

    @property
    def route_direction(self) -> TapiCommonForwardingDirection:
        """Gets the route_direction of this TapiConnectivityConnectivityService.


        :return: The route_direction of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonForwardingDirection
        """
        return self._route_direction

    @route_direction.setter
    def route_direction(self, route_direction: TapiCommonForwardingDirection):
        """Sets the route_direction of this TapiConnectivityConnectivityService.


        :param route_direction: The route_direction of this TapiConnectivityConnectivityService.
        :type route_direction: TapiCommonForwardingDirection
        """

        self._route_direction = route_direction

    @property
    def include_node(self) -> List[str]:
        """Gets the include_node of this TapiConnectivityConnectivityService.

        This is a loose constraint - that is it is unordered and could be a partial list  # noqa: E501

        :return: The include_node of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._include_node

    @include_node.setter
    def include_node(self, include_node: List[str]):
        """Sets the include_node of this TapiConnectivityConnectivityService.

        This is a loose constraint - that is it is unordered and could be a partial list  # noqa: E501

        :param include_node: The include_node of this TapiConnectivityConnectivityService.
        :type include_node: List[str]
        """

        self._include_node = include_node

    @property
    def exclude_link(self) -> List[str]:
        """Gets the exclude_link of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The exclude_link of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._exclude_link

    @exclude_link.setter
    def exclude_link(self, exclude_link: List[str]):
        """Sets the exclude_link of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param exclude_link: The exclude_link of this TapiConnectivityConnectivityService.
        :type exclude_link: List[str]
        """

        self._exclude_link = exclude_link

    @property
    def avoid_topology(self) -> List[str]:
        """Gets the avoid_topology of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The avoid_topology of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._avoid_topology

    @avoid_topology.setter
    def avoid_topology(self, avoid_topology: List[str]):
        """Sets the avoid_topology of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param avoid_topology: The avoid_topology of this TapiConnectivityConnectivityService.
        :type avoid_topology: List[str]
        """

        self._avoid_topology = avoid_topology

    @property
    def exclude_path(self) -> List[str]:
        """Gets the exclude_path of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The exclude_path of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._exclude_path

    @exclude_path.setter
    def exclude_path(self, exclude_path: List[str]):
        """Sets the exclude_path of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param exclude_path: The exclude_path of this TapiConnectivityConnectivityService.
        :type exclude_path: List[str]
        """

        self._exclude_path = exclude_path

    @property
    def include_link(self) -> List[str]:
        """Gets the include_link of this TapiConnectivityConnectivityService.

        This is a loose constraint - that is it is unordered and could be a partial list   # noqa: E501

        :return: The include_link of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._include_link

    @include_link.setter
    def include_link(self, include_link: List[str]):
        """Sets the include_link of this TapiConnectivityConnectivityService.

        This is a loose constraint - that is it is unordered and could be a partial list   # noqa: E501

        :param include_link: The include_link of this TapiConnectivityConnectivityService.
        :type include_link: List[str]
        """

        self._include_link = include_link

    @property
    def preferred_transport_layer(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the preferred_transport_layer of this TapiConnectivityConnectivityService.

        soft constraint requested by client to indicate the layer(s) of transport connection that it prefers to carry the service. This could be same as the service layer or one of the supported server layers  # noqa: E501

        :return: The preferred_transport_layer of this TapiConnectivityConnectivityService.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._preferred_transport_layer

    @preferred_transport_layer.setter
    def preferred_transport_layer(self, preferred_transport_layer: List[TapiCommonLayerProtocolName]):
        """Sets the preferred_transport_layer of this TapiConnectivityConnectivityService.

        soft constraint requested by client to indicate the layer(s) of transport connection that it prefers to carry the service. This could be same as the service layer or one of the supported server layers  # noqa: E501

        :param preferred_transport_layer: The preferred_transport_layer of this TapiConnectivityConnectivityService.
        :type preferred_transport_layer: List[TapiCommonLayerProtocolName]
        """

        self._preferred_transport_layer = preferred_transport_layer

    @property
    def exclude_node(self) -> List[str]:
        """Gets the exclude_node of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The exclude_node of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._exclude_node

    @exclude_node.setter
    def exclude_node(self, exclude_node: List[str]):
        """Sets the exclude_node of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param exclude_node: The exclude_node of this TapiConnectivityConnectivityService.
        :type exclude_node: List[str]
        """

        self._exclude_node = exclude_node

    @property
    def include_topology(self) -> List[str]:
        """Gets the include_topology of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The include_topology of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._include_topology

    @include_topology.setter
    def include_topology(self, include_topology: List[str]):
        """Sets the include_topology of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param include_topology: The include_topology of this TapiConnectivityConnectivityService.
        :type include_topology: List[str]
        """

        self._include_topology = include_topology

    @property
    def include_path(self) -> List[str]:
        """Gets the include_path of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The include_path of this TapiConnectivityConnectivityService.
        :rtype: List[str]
        """
        return self._include_path

    @include_path.setter
    def include_path(self, include_path: List[str]):
        """Sets the include_path of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param include_path: The include_path of this TapiConnectivityConnectivityService.
        :type include_path: List[str]
        """

        self._include_path = include_path

    @property
    def operational_state(self) -> TapiCommonOperationalState:
        """Gets the operational_state of this TapiConnectivityConnectivityService.


        :return: The operational_state of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonOperationalState
        """
        return self._operational_state

    @operational_state.setter
    def operational_state(self, operational_state: TapiCommonOperationalState):
        """Sets the operational_state of this TapiConnectivityConnectivityService.


        :param operational_state: The operational_state of this TapiConnectivityConnectivityService.
        :type operational_state: TapiCommonOperationalState
        """

        self._operational_state = operational_state

    @property
    def lifecycle_state(self) -> TapiCommonLifecycleState:
        """Gets the lifecycle_state of this TapiConnectivityConnectivityService.


        :return: The lifecycle_state of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonLifecycleState
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state: TapiCommonLifecycleState):
        """Sets the lifecycle_state of this TapiConnectivityConnectivityService.


        :param lifecycle_state: The lifecycle_state of this TapiConnectivityConnectivityService.
        :type lifecycle_state: TapiCommonLifecycleState
        """

        self._lifecycle_state = lifecycle_state

    @property
    def administrative_state(self) -> TapiCommonAdministrativeState:
        """Gets the administrative_state of this TapiConnectivityConnectivityService.


        :return: The administrative_state of this TapiConnectivityConnectivityService.
        :rtype: TapiCommonAdministrativeState
        """
        return self._administrative_state

    @administrative_state.setter
    def administrative_state(self, administrative_state: TapiCommonAdministrativeState):
        """Sets the administrative_state of this TapiConnectivityConnectivityService.


        :param administrative_state: The administrative_state of this TapiConnectivityConnectivityService.
        :type administrative_state: TapiCommonAdministrativeState
        """

        self._administrative_state = administrative_state

    @property
    def end_point(self) -> List[TapiConnectivityConnectivityServiceEndPoint]:
        """Gets the end_point of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The end_point of this TapiConnectivityConnectivityService.
        :rtype: List[TapiConnectivityConnectivityServiceEndPoint]
        """
        return self._end_point

    @end_point.setter
    def end_point(self, end_point: List[TapiConnectivityConnectivityServiceEndPoint]):
        """Sets the end_point of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param end_point: The end_point of this TapiConnectivityConnectivityService.
        :type end_point: List[TapiConnectivityConnectivityServiceEndPoint]
        """

        self._end_point = end_point

    @property
    def connection(self) -> List[TapiConnectivityConnectionRef]:
        """Gets the connection of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :return: The connection of this TapiConnectivityConnectivityService.
        :rtype: List[TapiConnectivityConnectionRef]
        """
        return self._connection

    @connection.setter
    def connection(self, connection: List[TapiConnectivityConnectionRef]):
        """Sets the connection of this TapiConnectivityConnectivityService.

        none  # noqa: E501

        :param connection: The connection of this TapiConnectivityConnectivityService.
        :type connection: List[TapiConnectivityConnectionRef]
        """

        self._connection = connection
