# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import Tuple
from common.proto.context_pb2 import ComponentId
from common.method_wrappers.ServiceExceptions import InvalidArgumentsException
from ._Builder import get_uuid_from_string, get_uuid_random
from .Device import device_get_uuid

def component_get_uuid(
    component_id: ComponentId, component_name: str = '', allow_random: bool = False
) -> str:
    device_uuid = device_get_uuid(component_id.device_id, allow_random=False)
    raw_component_uuid = component_id.component_uuid.uuid

    if raw_component_uuid:
        prefix_for_name = f'{device_uuid}'
        return get_uuid_from_string(raw_component_uuid, prefix_for_name=prefix_for_name)

    if component_name:
        prefix_for_name = f'{device_uuid}'
        return get_uuid_from_string(component_name, prefix_for_name=prefix_for_name)

    if allow_random:
        return get_uuid_random()

    raise InvalidArgumentsException(
        [
            ('component_id.component_uuid.uuid', raw_component_uuid),
            ('name', component_name),
        ],
        extra_details=['At least one is required to produce a Component UUID']
    )

