from app.service.rest_server.RestServer import RestServer
from .Resources import (
    CreateQKDApp, Index)

URL_PREFIX = '/app'

# Use 'path' type since some identifiers might contain char '/' and Flask is unable to recognize them in 'string' type.
RESOURCES = [
    # (endpoint_name, resource_class, resource_url)
    ('api.index',    Index,    '/'),
    ('api.register_qkd_app',    CreateQKDApp,    '/create_qkd_app'),
]

def register_qkd_app(app_server : RestServer):
    for endpoint_name, resource_class, resource_url in RESOURCES:
        app_server.add_resource(resource_class, URL_PREFIX + resource_url, endpoint=endpoint_name)
