import enum, functools
from common.proto.app_pb2 import QKDAppStatusEnum
from ._GrpcToEnum import grpc_to_enum

class ORM_QKDAppStatusEnum(enum.Enum):
    ON           = QKDAppStatusEnum.QKDAPPSTATUS_ON
    DISCONNECTED = QKDAppStatusEnum.QKDAPPSTATUS_DISCONNECTED
    OUT_OF_TIME  = QKDAppStatusEnum.QKDAPPSTATUS_OUT_OF_TIME
    ZOMBIE       = QKDAppStatusEnum.QKDAPPSTATUS_ZOMBIE


grpc_to_enum__qkd_app_status = functools.partial(
    grpc_to_enum, QKDAppStatusEnum, ORM_QKDAppStatusEnum)
