import logging, sqlalchemy
from common.Constants import ServiceNameEnum
from common.Settings import get_service_port_grpc
from common.message_broker.MessageBroker import MessageBroker
from common.proto.app_pb2_grpc import add_AppServiceServicer_to_server
from common.tools.service.GenericGrpcService import GenericGrpcService
from app.service.AppServiceServicerImpl import AppServiceServicerImpl

# Custom gRPC settings
GRPC_MAX_WORKERS = 200 # multiple clients might keep connections alive for Get*Events() RPC methods
LOGGER = logging.getLogger(__name__)


class AppService(GenericGrpcService):
    def __init__(
        self, db_engine : sqlalchemy.engine.Engine, messagebroker : MessageBroker, cls_name: str = __name__
    ) -> None:
        port = get_service_port_grpc(ServiceNameEnum.APP)
        super().__init__(port, max_workers=GRPC_MAX_WORKERS, cls_name=cls_name)
        self.app_servicer = AppServiceServicerImpl(db_engine, messagebroker)

    def install_servicers(self):
        add_AppServiceServicer_to_server(self.app_servicer, self.server)
