##### LLUIS GIFRE (CTTC): CODE UNDER REARRANGEMENT #####

# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import copy, logging, pytest
from common.Settings import get_setting
from common.proto.monitoring_pb2 import KpiDescriptorList
from common.tests.EventTools import EVENT_CREATE, EVENT_UPDATE, check_events
from common.tools.object_factory.Context import json_context_id
from common.tools.object_factory.Device import json_device_id
from common.tools.object_factory.Link import json_link_id
from common.tools.object_factory.Topology import json_topology_id
from context.client.ContextClient import ContextClient
from monitoring.client.MonitoringClient import MonitoringClient
from context.client.EventsCollector import EventsCollector
from common.proto.context_pb2 import Context, ContextId, Device, Empty, Link, Topology
from device.client.DeviceClient import DeviceClient
from .Objects import CONTEXT_ID, CONTEXTS, DEVICES, LINKS, TOPOLOGIES
from tests.Fixtures import context_client, device_client, monitoring_client

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)


def test_scenario_empty(context_client : ContextClient):  # pylint: disable=redefined-outer-name
    # ----- List entities - Ensure database is empty -------------------------------------------------------------------
    response = context_client.ListContexts(Empty())
    assert len(response.contexts) == 0

    response = context_client.ListDevices(Empty())
    assert len(response.devices) == 0

    response = context_client.ListLinks(Empty())
    assert len(response.links) == 0


def test_prepare_environment(context_client : ContextClient):  # pylint: disable=redefined-outer-name

    for context  in CONTEXTS  : context_client.SetContext (Context (**context ))
    for topology in TOPOLOGIES: context_client.SetTopology(Topology(**topology))

    for device, connect_rules in DEVICES:
        device_with_connect_rules = copy.deepcopy(device)
        device_with_connect_rules['device_config']['config_rules'].extend(connect_rules)
        device_client.AddDevice(Device(**device_with_connect_rules))


    for link     in LINKS     : context_client.SetLink    (Link    (**link    ))




def test_scenario_ready(context_client : ContextClient):  # pylint: disable=redefined-outer-name
    # ----- List entities - Ensure scenario is ready -------------------------------------------------------------------
    response = context_client.ListContexts(Empty())
    assert len(response.contexts) == len(CONTEXTS)

    response = context_client.ListTopologies(ContextId(**CONTEXT_ID))
    assert len(response.topologies) == len(TOPOLOGIES)

    response = context_client.ListDevices(Empty())
    assert len(response.devices) == len(DEVICES)

    response = context_client.ListLinks(Empty())
    assert len(response.links) == len(LINKS)

    response = context_client.ListServices(ContextId(**CONTEXT_ID))
    assert len(response.services) == 0

def test_scenario_kpis_created(monitoring_client: MonitoringClient):
    """
    This test validates that KPIs related to the service/device/endpoint were created
    during the service creation process.
    """
    response: KpiDescriptorList = monitoring_client.GetKpiDescriptorList(Empty())
    # TODO: replace the magic number `16` below for a formula that adapts to the number
    # of links and devices
    assert len(response.kpi_descriptor_list) >= 16
