# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import json, logging
from common.tools.descriptor.Loader import DescriptorLoader, compose_notifications
from context.client.ContextClient import ContextClient
from device.client.DeviceClient import DeviceClient
from service.client.ServiceClient import ServiceClient
from slice.client.SliceClient import SliceClient

LOGGER = logging.getLogger(__name__)
LOGGERS = {
    'success': LOGGER.info,
    'danger' : LOGGER.error,
    'error'  : LOGGER.error,
}

def load_scenario_from_descriptor(
    descriptor_file : str, context_client : ContextClient, device_client : DeviceClient,
    service_client : ServiceClient, slice_client : SliceClient
) -> None:
    with open(descriptor_file, 'r', encoding='UTF-8') as f:
        descriptors = json.loads(f.read())

    descriptor_loader = DescriptorLoader(
        context_client=context_client, device_client=device_client,
        service_client=service_client, slice_client=slice_client)
    descriptor_loader.process_descriptors(descriptors)
    results = descriptor_loader.get_results()

    num_errors = 0
    for message,level in compose_notifications(results):
        LOGGERS.get(level)(message)
        if level != 'success': num_errors += 1
    if num_errors > 0:
        MSG = 'Failed to load descriptors in file {:s}'
        raise Exception(MSG.format(str(descriptor_file)))
