from copy import deepcopy
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from context.proto.context_pb2 import ConfigActionEnum, DeviceDriverEnum, DeviceOperationalStatusEnum

try:
    from ._device_credentials import (
        DEVICE1_UUID, DEVICE1_TYPE, DEVICE1_ADDRESS, DEVICE1_PORT, DEVICE1_USERNAME, DEVICE1_PASSWORD, DEVICE1_HANDLER,
        DEVICE1_DRIVERS)
except ImportError:
    DEVICE1_UUID     = 'DEV1'
    DEVICE1_TYPE     = 'packet-router'
    DEVICE1_ADDRESS  = '127.0.0.1'
    DEVICE1_PORT     = '830'
    DEVICE1_USERNAME = 'username'
    DEVICE1_PASSWORD = 'password'
    DEVICE1_HANDLER  = 'default'
    DEVICE1_DRIVERS  = [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG]

# Some example objects to be used by the tests

# Helper methods
def config_rule(action, resource_key, resource_value):
    return {'action': action, 'resource_key': resource_key, 'resource_value': resource_value}

def endpoint_id(topology_id, device_id, endpoint_uuid):
    return {'topology_id': deepcopy(topology_id), 'device_id': deepcopy(device_id),
            'endpoint_uuid': {'uuid': endpoint_uuid}}

def endpoint(topology_id, device_id, endpoint_uuid, endpoint_type):
    return {'endpoint_id': endpoint_id(topology_id, device_id, endpoint_uuid), 'endpoint_type': endpoint_type}

## use "deepcopy" to prevent propagating forced changes during tests
CONTEXT_ID = {'context_uuid': {'uuid': DEFAULT_CONTEXT_UUID}}
CONTEXT = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_ids': [],
    'service_ids': [],
}

TOPOLOGY_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_uuid': {'uuid': DEFAULT_TOPOLOGY_UUID},
}
TOPOLOGY = {
    'topology_id': deepcopy(TOPOLOGY_ID),
    'device_ids': [],
    'link_ids': [],
}

DEVICE1_ID = {'device_uuid': {'uuid': DEVICE1_UUID}}
DEVICE1 = {
    'device_id': deepcopy(DEVICE1_ID),
    'device_type': DEVICE1_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE1_DRIVERS,
    'device_endpoints': [],
}

DEVICE1_CONNECT_RULES = [
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/address',  DEVICE1_ADDRESS ),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/port',     DEVICE1_PORT    ),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/username', DEVICE1_USERNAME),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/password', DEVICE1_PASSWORD),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/handler',  DEVICE1_HANDLER ),
]

DEVICE1_CONFIG_RULES = [
    config_rule(ConfigActionEnum.CONFIGACTION_SET, 'dev/rsrc1/value', 'value1'),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, 'dev/rsrc2/value', 'value2'),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, 'dev/rsrc3/value', 'value3'),
]
