# Handler for Infinera device specific information through YANG.
from ncclient.xml_ import BASE_NS_1_0
from ncclient.devices.default import DefaultDeviceHandler

class InfineraDeviceHandler(DefaultDeviceHandler):
    _EXEMPT_ERRORS = []

    def get_capabilities(self):
        return [
            'urn:ietf:params:netconf:base:1.0',
            'urn:ietf:params:netconf:base:1.1',
        ]

    def get_xml_base_namespace_dict(self):
        return {None: BASE_NS_1_0}

    def get_xml_extra_prefix_kwargs(self):
        return {'nsmap': self.get_xml_base_namespace_dict()}
